/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.impl;

import com.voxelbridge.shadow.jgltf.model.AccessorDatas;
import com.voxelbridge.shadow.jgltf.model.AccessorFloatData;
import com.voxelbridge.shadow.jgltf.model.AccessorModel;
import com.voxelbridge.shadow.jgltf.model.MathUtils;
import com.voxelbridge.shadow.jgltf.model.NodeModel;
import com.voxelbridge.shadow.jgltf.model.SkinModel;
import com.voxelbridge.shadow.jgltf.model.Utils;
import com.voxelbridge.shadow.jgltf.model.impl.AbstractNamedModelElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class DefaultSkinModel
extends AbstractNamedModelElement
implements SkinModel {
    private float[] bindShapeMatrix = MathUtils.createIdentity4x4();
    private final List<NodeModel> joints = new ArrayList<NodeModel>();
    private NodeModel skeleton;
    private AccessorModel inverseBindMatrices;

    public void setBindShapeMatrix(float[] bindShapeMatrix) {
        this.bindShapeMatrix = bindShapeMatrix == null ? MathUtils.createIdentity4x4() : (float[])bindShapeMatrix.clone();
    }

    public void addJoint(NodeModel joint) {
        Objects.requireNonNull(joint, "The joint may not be null");
        this.joints.add(joint);
    }

    public void setSkeleton(NodeModel skeleton) {
        this.skeleton = skeleton;
    }

    public void setInverseBindMatrices(AccessorModel inverseBindMatrices) {
        this.inverseBindMatrices = Objects.requireNonNull(inverseBindMatrices, "The inverseBindMatrices may not be null");
    }

    @Override
    public float[] getBindShapeMatrix(float[] result) {
        float[] localResult = Utils.validate(result, 16);
        System.arraycopy(this.bindShapeMatrix, 0, localResult, 0, 16);
        return localResult;
    }

    @Override
    public List<NodeModel> getJoints() {
        return Collections.unmodifiableList(this.joints);
    }

    @Override
    public NodeModel getSkeleton() {
        return this.skeleton;
    }

    @Override
    public AccessorModel getInverseBindMatrices() {
        return this.inverseBindMatrices;
    }

    @Override
    public float[] getInverseBindMatrix(int index, float[] result) {
        float[] localResult = Utils.validate(result, 16);
        AccessorFloatData inverseBindMatricesData = AccessorDatas.createFloat(this.inverseBindMatrices);
        for (int j = 0; j < 16; ++j) {
            localResult[j] = inverseBindMatricesData.get(index, j);
        }
        return localResult;
    }
}

