/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.impl;

import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.io.MimeTypes;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.logging.Logger;

public class UriStrings {
    private static final Logger logger = Logger.getLogger(UriStrings.class.getName());

    public static String createBufferUriString(Collection<? extends String> existingUriStrings) {
        int counter = 0;
        String uri;
        while (existingUriStrings.contains(uri = "buffer" + counter + ".bin")) {
            ++counter;
        }
        return uri;
    }

    public static String createImageUriString(ImageModel imageModel, Collection<? extends String> existingUriStrings) {
        String extensionWithoutDot = UriStrings.determineImageFileNameExtension(imageModel);
        int counter = 0;
        String uri;
        while (existingUriStrings.contains(uri = "image" + counter + "." + extensionWithoutDot)) {
            ++counter;
        }
        return uri;
    }

    private static String determineImageFileNameExtension(ImageModel imageModel) {
        String extensionWithoutDot;
        String mimeTypeString = imageModel.getMimeType();
        if (mimeTypeString == null) {
            ByteBuffer imageData = imageModel.getImageData();
            mimeTypeString = MimeTypes.guessImageMimeTypeStringUnchecked(imageData);
        }
        if (mimeTypeString != null && (extensionWithoutDot = MimeTypes.imageFileNameExtensionForMimeTypeString(mimeTypeString)) != null) {
            return extensionWithoutDot;
        }
        logger.warning("Could not determine file extension for image URI");
        return "";
    }

    public static String createShaderUriString(ShaderModel shaderModel, Collection<? extends String> existingUriStrings) {
        String extensionWithoutDot = UriStrings.determineShaderFileNameExtension(shaderModel);
        int counter = 0;
        String uri;
        while (existingUriStrings.contains(uri = "shader" + counter + "." + extensionWithoutDot)) {
            ++counter;
        }
        return uri;
    }

    private static String determineShaderFileNameExtension(ShaderModel shaderModel) {
        if (shaderModel.getShaderType() == ShaderModel.ShaderType.VERTEX_SHADER) {
            return "vert";
        }
        return "frag";
    }

    private UriStrings() {
    }
}

