/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io;

import com.voxelbridge.shadow.jgltf.model.io.GltfAsset;
import com.voxelbridge.shadow.jgltf.model.io.GltfReference;
import com.voxelbridge.shadow.jgltf.model.io.IO;
import java.nio.ByteBuffer;
import java.util.List;

public class GltfAssets {
    public static boolean isDefault(GltfAsset gltfAsset) {
        ByteBuffer binaryData = gltfAsset.getBinaryData();
        if (binaryData != null && binaryData.capacity() > 0) {
            return false;
        }
        return !GltfAssets.containsDataUriReferences(gltfAsset);
    }

    public static boolean isEmbedded(GltfAsset gltfAsset) {
        ByteBuffer binaryData = gltfAsset.getBinaryData();
        if (binaryData != null && binaryData.capacity() > 0) {
            return false;
        }
        return !GltfAssets.containsFileUriReferences(gltfAsset);
    }

    public static boolean isBinary(GltfAsset gltfAsset) {
        if (GltfAssets.containsFileUriReferences(gltfAsset)) {
            return false;
        }
        return !GltfAssets.containsDataUriReferences(gltfAsset);
    }

    private static boolean containsFileUriReferences(GltfAsset gltfAsset) {
        List<GltfReference> references = gltfAsset.getReferences();
        for (GltfReference reference : references) {
            String uriString = reference.getUri();
            if (IO.isDataUriString(uriString)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsDataUriReferences(GltfAsset gltfAsset) {
        List<GltfReference> references = gltfAsset.getReferences();
        for (GltfReference reference : references) {
            String uriString = reference.getUri();
            if (IO.isDataUriString(uriString)) continue;
            return true;
        }
        return false;
    }

    private GltfAssets() {
    }
}

