/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.model.io.JacksonUtils;
import com.voxelbridge.shadow.jgltf.model.io.JsonError;
import com.voxelbridge.shadow.jgltf.model.io.VersionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.logging.Logger;

final class GltfReader {
    private static final Logger logger = Logger.getLogger(GltfReader.class.getName());
    private Consumer<? super JsonError> jsonErrorConsumer = JacksonUtils.loggingJsonErrorConsumer();
    private final ObjectMapper objectMapper = JacksonUtils.createObjectMapper(this.jsonErrorConsumer);
    private JsonNode rootNode;

    GltfReader() {
    }

    void setJsonErrorConsumer(Consumer<? super JsonError> jsonErrorConsumer) {
        this.jsonErrorConsumer = jsonErrorConsumer;
    }

    void read(InputStream inputStream) throws IOException {
        JacksonUtils.configure(this.objectMapper, this.jsonErrorConsumer);
        this.rootNode = this.objectMapper.readTree(inputStream);
    }

    String getVersion() {
        if (this.rootNode == null) {
            return null;
        }
        return GltfReader.getVersion(this.rootNode);
    }

    int getMajorVersion() {
        if (this.rootNode == null) {
            return 0;
        }
        int[] version = VersionUtils.computeMajorMinorPatch(this.getVersion());
        return version[0];
    }

    GlTF getAsGltfV1() {
        if (this.rootNode == null) {
            return null;
        }
        return this.objectMapper.convertValue((Object)this.rootNode, GlTF.class);
    }

    com.voxelbridge.shadow.jgltf.impl.v2.GlTF getAsGltfV2() {
        if (this.rootNode == null) {
            return null;
        }
        return this.objectMapper.convertValue((Object)this.rootNode, com.voxelbridge.shadow.jgltf.impl.v2.GlTF.class);
    }

    private static String getVersion(JsonNode rootNode) {
        JsonNode assetNode = rootNode.get("asset");
        if (assetNode == null) {
            return "1.0";
        }
        JsonNode versionNode = assetNode.get("version");
        if (versionNode == null) {
            return "1.0";
        }
        if (!versionNode.isValueNode()) {
            logger.warning("No valid 'version' property in 'asset'. Assuming version 1.0");
            return "1.0";
        }
        return versionNode.asText();
    }
}

