/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io;

import com.voxelbridge.shadow.jgltf.model.io.Buffers;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

public final class RawGltfData {
    private final ByteBuffer jsonData;
    private final ByteBuffer binaryData;

    public RawGltfData(ByteBuffer jsonData, ByteBuffer binaryData) {
        this.jsonData = Objects.requireNonNull(jsonData, "The jsonData may not be null");
        this.binaryData = binaryData;
    }

    public String getJsonString() {
        byte[] jsonDataArray = new byte[this.jsonData.capacity()];
        this.jsonData.slice().get(jsonDataArray);
        String jsonString = new String(jsonDataArray, Charset.forName("UTF-8"));
        return jsonString;
    }

    public ByteBuffer getJsonData() {
        return Buffers.createSlice(this.jsonData);
    }

    public ByteBuffer getBinaryData() {
        return Buffers.createSlice(this.binaryData);
    }
}

