/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io;

public class VersionUtils {
    public static int compareVersions(String v0, String v1) {
        int[] sv0 = VersionUtils.computeMajorMinorPatch(v0);
        int[] sv1 = VersionUtils.computeMajorMinorPatch(v1);
        for (int i = 0; i < 3; ++i) {
            int c = Integer.compare(sv0[i], sv1[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    static int[] computeMajorMinorPatch(String v) {
        int[] result = new int[3];
        String[] tokens = v.split("\\.");
        int n = Math.min(tokens.length, 3);
        for (int i = 0; i < n; ++i) {
            String token = tokens[i];
            result[i] = VersionUtils.parseIntPrefix(token);
        }
        return result;
    }

    private static int parseIntPrefix(String s) {
        char c;
        String number = "";
        for (int j = 0; j < s.length() && Character.isDigit(c = s.charAt(j)); ++j) {
            number = number + c;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

