/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v1;

import com.voxelbridge.shadow.jgltf.impl.v1.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v1.BufferView;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v1.Image;
import com.voxelbridge.shadow.jgltf.impl.v1.Shader;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.io.Buffers;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfUtilsV1;
import com.voxelbridge.shadow.jgltf.model.v1.BinaryGltfV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfCreatorV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfExtensionsV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfIds;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class BinaryAssetCreatorV1 {
    BinaryAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        GlTF outputGltf = GltfCreatorV1.create(gltfModel);
        int binaryGltfBufferSize = BinaryAssetCreatorV1.computeBinaryGltfBufferSize(gltfModel);
        ByteBuffer binaryGltfByteBuffer = Buffers.create(binaryGltfBufferSize);
        GltfExtensionsV1.addExtensionUsed(outputGltf, BinaryGltfV1.getBinaryGltfExtensionName());
        Buffer binaryGltfBuffer = new Buffer();
        binaryGltfBuffer.setType("arraybuffer");
        binaryGltfBuffer.setUri(BinaryGltfV1.getBinaryGltfBufferId() + ".bin");
        binaryGltfBuffer.setByteLength(binaryGltfBufferSize);
        Map<String, Buffer> newBuffers = Collections.singletonMap(BinaryGltfV1.getBinaryGltfBufferId(), binaryGltfBuffer);
        Map<String, Buffer> oldBuffers = BinaryAssetCreatorV1.copy(outputGltf.getBuffers());
        Map<String, Image> oldImages = BinaryAssetCreatorV1.copy(outputGltf.getImages());
        Map<String, Shader> oldShaders = BinaryAssetCreatorV1.copy(outputGltf.getShaders());
        Map<String, BufferModel> bufferIdToBuffer = GltfUtilsV1.createMap(oldBuffers, gltfModel.getBufferModels());
        Map<String, ImageModel> imageIdToImage = GltfUtilsV1.createMap(oldImages, gltfModel.getImageModels());
        Map<String, ShaderModel> shaderIdToShader = GltfUtilsV1.createMap(oldShaders, gltfModel.getShaderModels());
        Map<String, Integer> bufferOffsets = BinaryAssetCreatorV1.concatBuffers(oldBuffers.keySet(), id -> ((BufferModel)bufferIdToBuffer.get(id)).getBufferData(), binaryGltfByteBuffer);
        Map<String, Integer> imageOffsets = BinaryAssetCreatorV1.concatBuffers(oldImages.keySet(), id -> {
            ImageModel image = (ImageModel)imageIdToImage.get(id);
            if (image.getBufferViewModel() != null) {
                return ByteBuffer.allocate(0);
            }
            return image.getImageData();
        }, binaryGltfByteBuffer);
        Map<String, Integer> shaderOffsets = BinaryAssetCreatorV1.concatBuffers(oldShaders.keySet(), id -> {
            ShaderModel shader = (ShaderModel)shaderIdToShader.get(id);
            if (shader.getBufferViewModel() != null) {
                return ByteBuffer.allocate(0);
            }
            return shader.getShaderData();
        }, binaryGltfByteBuffer);
        binaryGltfByteBuffer.position(0);
        Map<String, BufferView> oldBufferViews = BinaryAssetCreatorV1.copy(outputGltf.getBufferViews());
        LinkedHashMap<String, BufferView> newBufferViews = new LinkedHashMap<String, BufferView>();
        for (Map.Entry<String, BufferView> entry : oldBufferViews.entrySet()) {
            String string = entry.getKey();
            BufferView oldBufferView = entry.getValue();
            BufferView newBufferView = GltfUtilsV1.copy(oldBufferView);
            newBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
            String oldBufferId = oldBufferView.getBuffer();
            int oldByteOffset = oldBufferView.getByteOffset();
            int bufferOffset = bufferOffsets.get(oldBufferId);
            int newByteOffset = oldByteOffset + bufferOffset;
            newBufferView.setByteOffset(newByteOffset);
            newBufferViews.put(string, newBufferView);
        }
        LinkedHashMap<String, Image> newImages = new LinkedHashMap<String, Image>();
        for (Map.Entry<String, Image> entry : oldImages.entrySet()) {
            String id3 = entry.getKey();
            Image oldImage = entry.getValue();
            Image newImage = GltfUtilsV1.copy(oldImage);
            if (!BinaryGltfV1.hasBinaryGltfExtension(oldImage)) {
                ByteBuffer imageData = imageIdToImage.get(id3).getImageData();
                int byteLength = imageData.capacity();
                int byteOffset = imageOffsets.get(id3);
                BufferView imageBufferView = new BufferView();
                imageBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
                imageBufferView.setByteOffset(byteOffset);
                imageBufferView.setByteLength(byteLength);
                String generatedBufferViewId = GltfIds.generateId("bufferView_for_image_" + id3, oldBufferViews.keySet());
                newBufferViews.put(generatedBufferViewId, imageBufferView);
                BinaryGltfV1.setBinaryGltfBufferViewId(newImage, generatedBufferViewId);
                newImage.setUri("image_" + id3);
                BinaryGltfV1.setBinaryGltfImageProperties(newImage, imageData);
            } else {
                List<BufferViewModel> bufferViewModels = gltfModel.getBufferViewModels();
                ImageModel imageModel = imageIdToImage.get(id3);
                BufferViewModel imageBufferViewModel = imageModel.getBufferViewModel();
                int index = bufferViewModels.indexOf(imageBufferViewModel);
                String newId = "bufferView_" + index;
                BinaryGltfV1.setBinaryGltfBufferViewId(newImage, newId);
            }
            newImages.put(id3, newImage);
        }
        LinkedHashMap<String, Shader> linkedHashMap = new LinkedHashMap<String, Shader>();
        for (Map.Entry<String, Shader> oldEntry : oldShaders.entrySet()) {
            String id4 = oldEntry.getKey();
            Shader oldShader = oldEntry.getValue();
            Shader newShader = GltfUtilsV1.copy(oldShader);
            if (!BinaryGltfV1.hasBinaryGltfExtension(oldShader)) {
                ByteBuffer shaderData = shaderIdToShader.get(id4).getShaderData();
                int byteLength = shaderData.capacity();
                int byteOffset = shaderOffsets.get(id4);
                BufferView shaderBufferView = new BufferView();
                shaderBufferView.setBuffer(BinaryGltfV1.getBinaryGltfBufferId());
                shaderBufferView.setByteOffset(byteOffset);
                shaderBufferView.setByteLength(byteLength);
                String generatedBufferViewId = GltfIds.generateId("bufferView_for_shader_" + id4, oldBufferViews.keySet());
                newBufferViews.put(generatedBufferViewId, shaderBufferView);
                BinaryGltfV1.setBinaryGltfBufferViewId(newShader, generatedBufferViewId);
            } else {
                List<BufferViewModel> bufferViewModels = gltfModel.getBufferViewModels();
                ShaderModel shaderModel = shaderIdToShader.get(id4);
                BufferViewModel shaderBufferViewModel = shaderModel.getBufferViewModel();
                int index = bufferViewModels.indexOf(shaderBufferViewModel);
                String newId = "bufferView_" + index;
                BinaryGltfV1.setBinaryGltfBufferViewId(newShader, newId);
            }
            linkedHashMap.put(id4, newShader);
        }
        if (!newBuffers.isEmpty()) {
            outputGltf.setBuffers(newBuffers);
        }
        if (!newImages.isEmpty()) {
            outputGltf.setImages(newImages);
        }
        if (!linkedHashMap.isEmpty()) {
            outputGltf.setShaders(linkedHashMap);
        }
        if (!newBufferViews.isEmpty()) {
            outputGltf.setBufferViews(newBufferViews);
        }
        return new GltfAssetV1(outputGltf, binaryGltfByteBuffer);
    }

    private static int computeBinaryGltfBufferSize(GltfModelV1 gltfModel) {
        int binaryGltfBufferSize = 0;
        for (BufferModel bufferModel : gltfModel.getBufferModels()) {
            ByteBuffer bufferData = bufferModel.getBufferData();
            binaryGltfBufferSize += bufferData.capacity();
        }
        for (ImageModel imageModel : gltfModel.getImageModels()) {
            if (imageModel.getBufferViewModel() != null) continue;
            ByteBuffer imageData = imageModel.getImageData();
            binaryGltfBufferSize += imageData.capacity();
        }
        for (ShaderModel shaderModel : gltfModel.getShaderModels()) {
            if (shaderModel.getBufferViewModel() != null) continue;
            ByteBuffer shaderData = shaderModel.getShaderData();
            binaryGltfBufferSize += shaderData.capacity();
        }
        return binaryGltfBufferSize;
    }

    private static <K> Map<K, Integer> concatBuffers(Iterable<K> keys, Function<? super K, ? extends ByteBuffer> keyToByteBuffer, ByteBuffer targetBuffer) {
        LinkedHashMap<K, Integer> offsets = new LinkedHashMap<K, Integer>();
        for (K key : keys) {
            ByteBuffer oldByteBuffer = keyToByteBuffer.apply(key);
            int offset = targetBuffer.position();
            offsets.put(key, offset);
            targetBuffer.put(oldByteBuffer.slice());
        }
        return offsets;
    }

    private static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<K, V>(map);
    }
}

