/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v1;

import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultGltfModel;
import com.voxelbridge.shadow.jgltf.model.io.v1.DirectAssetCreatorV1;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.structure.GltfModelStructures;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import java.util.List;
import java.util.logging.Logger;

final class DefaultAssetCreatorV1 {
    private static final Logger logger = Logger.getLogger(DefaultAssetCreatorV1.class.getName());

    DefaultAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        boolean hasDefaultStructure = DefaultAssetCreatorV1.hasDefaultStructure(gltfModel);
        if (hasDefaultStructure) {
            logger.fine("The model has a default structure - creating asset");
            DirectAssetCreatorV1 delegate = new DirectAssetCreatorV1();
            return delegate.create(gltfModel);
        }
        logger.fine("Converting model into default structure");
        GltfModelStructures g = new GltfModelStructures();
        g.prepare(gltfModel);
        DefaultGltfModel defaultGltfModel = g.createDefault();
        DirectAssetCreatorV1 delegate = new DirectAssetCreatorV1();
        return delegate.create((GltfModelV1)defaultGltfModel);
    }

    private static boolean hasDefaultStructure(GltfModel gltfModel) {
        List<ImageModel> imageModels = gltfModel.getImageModels();
        for (ImageModel imageModel : imageModels) {
            BufferViewModel imageBufferViewModel = imageModel.getBufferViewModel();
            if (imageBufferViewModel == null) continue;
            return false;
        }
        return true;
    }
}

