/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v1;

import com.voxelbridge.shadow.jgltf.impl.v1.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v1.Image;
import com.voxelbridge.shadow.jgltf.impl.v1.Shader;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.Optionals;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.impl.UriStrings;
import com.voxelbridge.shadow.jgltf.model.io.IO;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfUtilsV1;
import com.voxelbridge.shadow.jgltf.model.v1.BinaryGltfV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfCreatorV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfExtensionsV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DirectAssetCreatorV1 {
    private GltfAssetV1 gltfAsset;
    private Set<String> existingBufferUriStrings;
    private Set<String> existingImageUriStrings;
    private Set<String> existingShaderUriStrings;

    DirectAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        GlTF outputGltf = GltfCreatorV1.create(gltfModel);
        GltfExtensionsV1.removeExtensionUsed(outputGltf, BinaryGltfV1.getBinaryGltfExtensionName());
        this.existingBufferUriStrings = DirectAssetCreatorV1.collectUriStrings(Optionals.of(outputGltf.getBuffers()).values(), Buffer::getUri);
        this.existingImageUriStrings = DirectAssetCreatorV1.collectUriStrings(Optionals.of(outputGltf.getImages()).values(), Image::getUri);
        this.existingShaderUriStrings = DirectAssetCreatorV1.collectUriStrings(Optionals.of(outputGltf.getShaders()).values(), Shader::getUri);
        this.gltfAsset = new GltfAssetV1(outputGltf, null);
        Map<String, BufferModel> bufferIdToBuffer = GltfUtilsV1.createMap(outputGltf.getBuffers(), gltfModel.getBufferModels());
        Map<String, ImageModel> imageIdToImage = GltfUtilsV1.createMap(outputGltf.getImages(), gltfModel.getImageModels());
        Map<String, ShaderModel> shaderIdToShader = GltfUtilsV1.createMap(outputGltf.getShaders(), gltfModel.getShaderModels());
        Optionals.of(outputGltf.getBuffers()).forEach((id, value) -> this.storeBufferAsDefault(gltfModel, (String)id, (Buffer)value, bufferIdToBuffer::get));
        Optionals.of(outputGltf.getImages()).forEach((id, value) -> this.storeImageAsDefault(gltfModel, (String)id, (Image)value, imageIdToImage::get));
        Optionals.of(outputGltf.getShaders()).forEach((id, value) -> this.storeShaderAsDefault(gltfModel, (String)id, (Shader)value, shaderIdToShader::get));
        return this.gltfAsset;
    }

    private static <T> Set<String> collectUriStrings(Collection<T> elements, Function<? super T, ? extends String> uriFunction) {
        return elements.stream().map(uriFunction).filter(Objects::nonNull).filter(uriString -> !IO.isDataUriString(uriString)).collect(Collectors.toSet());
    }

    private void storeBufferAsDefault(GltfModelV1 gltfModel, String id, Buffer buffer, Function<? super String, ? extends BufferModel> lookup) {
        String oldUriString;
        BufferModel bufferModel = lookup.apply(id);
        ByteBuffer bufferData = bufferModel.getBufferData();
        String newUriString = oldUriString = buffer.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.isBinaryGltfBufferId(id)) {
            newUriString = UriStrings.createBufferUriString(this.existingBufferUriStrings);
            buffer.setUri(newUriString);
            this.existingBufferUriStrings.add(newUriString);
        }
        this.gltfAsset.putReferenceData(newUriString, bufferData);
    }

    private void storeImageAsDefault(GltfModelV1 gltfModel, String id, Image image, Function<? super String, ? extends ImageModel> lookup) {
        String oldUriString;
        ImageModel imageModel = lookup.apply(id);
        ByteBuffer imageData = imageModel.getImageData();
        String newUriString = oldUriString = image.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.hasBinaryGltfExtension(image)) {
            newUriString = UriStrings.createImageUriString(imageModel, this.existingImageUriStrings);
            image.setUri(newUriString);
            this.existingImageUriStrings.add(newUriString);
            image.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        }
        this.gltfAsset.putReferenceData(newUriString, imageData);
    }

    private void storeShaderAsDefault(GltfModelV1 gltfModel, String id, Shader shader, Function<? super String, ? extends ShaderModel> lookup) {
        String oldUriString;
        ShaderModel shaderModel = lookup.apply(id);
        ByteBuffer shaderData = shaderModel.getShaderData();
        String newUriString = oldUriString = shader.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.hasBinaryGltfExtension(shader)) {
            newUriString = UriStrings.createShaderUriString(shaderModel, this.existingShaderUriStrings);
            shader.setUri(newUriString);
            this.existingShaderUriStrings.add(newUriString);
            shader.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        }
        this.gltfAsset.putReferenceData(newUriString, shaderData);
    }
}

