/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v1;

import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.model.io.GltfAsset;
import com.voxelbridge.shadow.jgltf.model.io.GltfAssetWriter;
import com.voxelbridge.shadow.jgltf.model.io.GltfWriter;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetWriterV1;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetsV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class GltfModelWriterV1 {
    public void write(GltfModelV1 gltfModel, File file) throws IOException {
        GltfAssetV1 gltfAsset = GltfAssetsV1.createDefault(gltfModel);
        GltfAssetWriter gltfAssetWriter = new GltfAssetWriter();
        gltfAssetWriter.write((GltfAsset)gltfAsset, file);
    }

    public void writeBinary(GltfModelV1 gltfModel, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.writeBinary(gltfModel, outputStream);
        }
    }

    public void writeBinary(GltfModelV1 gltfModel, OutputStream outputStream) throws IOException {
        GltfAssetV1 gltfAsset = GltfAssetsV1.createBinary(gltfModel);
        GltfAssetWriterV1 gltfAssetWriter = new GltfAssetWriterV1();
        gltfAssetWriter.writeBinary(gltfAsset, outputStream);
    }

    public void writeEmbedded(GltfModelV1 gltfModel, OutputStream outputStream) throws IOException {
        GltfAssetV1 gltfAsset = GltfAssetsV1.createEmbedded(gltfModel);
        GltfWriter gltfWriter = new GltfWriter();
        GlTF gltf = gltfAsset.getGltf();
        gltfWriter.write(gltf, outputStream);
    }
}

