/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v2;

import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultGltfModel;
import com.voxelbridge.shadow.jgltf.model.io.v2.DirectAssetCreatorV2;
import com.voxelbridge.shadow.jgltf.model.io.v2.GltfAssetV2;
import com.voxelbridge.shadow.jgltf.model.structure.GltfModelStructures;
import java.util.List;
import java.util.logging.Logger;

final class BinaryAssetCreatorV2 {
    private static final Logger logger = Logger.getLogger(BinaryAssetCreatorV2.class.getName());

    BinaryAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModel gltfModel) {
        boolean hasBinaryStructure = BinaryAssetCreatorV2.hasBinaryStructure(gltfModel);
        if (hasBinaryStructure) {
            logger.fine("The model has a binary structure - creating asset");
            DirectAssetCreatorV2 delegate = new DirectAssetCreatorV2();
            GltfAssetV2 binaryAsset = delegate.createBinary(gltfModel);
            return binaryAsset;
        }
        logger.fine("Converting model into binary structure");
        GltfModelStructures g = new GltfModelStructures();
        g.prepare(gltfModel);
        DefaultGltfModel binaryGltfModel = g.createBinary();
        DirectAssetCreatorV2 delegate = new DirectAssetCreatorV2();
        GltfAssetV2 binaryAsset = delegate.createBinary(binaryGltfModel);
        return binaryAsset;
    }

    private static boolean hasBinaryStructure(GltfModel gltfModel) {
        List<BufferModel> bufferModels = gltfModel.getBufferModels();
        if (bufferModels.size() >= 2) {
            return false;
        }
        List<ImageModel> imageModels = gltfModel.getImageModels();
        for (ImageModel imageModel : imageModels) {
            BufferViewModel imageBufferViewModel = imageModel.getBufferViewModel();
            if (imageBufferViewModel != null) continue;
            return false;
        }
        return true;
    }
}

