/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v2;

import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultGltfModel;
import com.voxelbridge.shadow.jgltf.model.io.v2.DirectAssetCreatorV2;
import com.voxelbridge.shadow.jgltf.model.io.v2.GltfAssetV2;
import com.voxelbridge.shadow.jgltf.model.structure.GltfModelStructures;
import java.util.List;
import java.util.logging.Logger;

final class DefaultAssetCreatorV2 {
    private static final Logger logger = Logger.getLogger(DefaultAssetCreatorV2.class.getName());

    DefaultAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModel gltfModel) {
        boolean hasDefaultStructure = DefaultAssetCreatorV2.hasDefaultStructure(gltfModel);
        if (hasDefaultStructure) {
            logger.fine("The model has a default structure - creating asset");
            DirectAssetCreatorV2 delegate = new DirectAssetCreatorV2();
            return delegate.createDefault(gltfModel);
        }
        logger.fine("Converting model into default structure");
        GltfModelStructures g = new GltfModelStructures();
        g.prepare(gltfModel);
        DefaultGltfModel defaultGltfModel = g.createDefault();
        DirectAssetCreatorV2 delegate = new DirectAssetCreatorV2();
        return delegate.createDefault(defaultGltfModel);
    }

    private static boolean hasDefaultStructure(GltfModel gltfModel) {
        List<ImageModel> imageModels = gltfModel.getImageModels();
        for (ImageModel imageModel : imageModels) {
            BufferViewModel imageBufferViewModel = imageModel.getBufferViewModel();
            if (imageBufferViewModel == null) continue;
            return false;
        }
        return true;
    }
}

