/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v2;

import com.voxelbridge.shadow.jgltf.impl.v2.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v2.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v2.Image;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.Optionals;
import com.voxelbridge.shadow.jgltf.model.io.v2.DataUris;
import com.voxelbridge.shadow.jgltf.model.io.v2.GltfAssetV2;
import com.voxelbridge.shadow.jgltf.model.v2.GltfCreatorV2;
import java.util.List;

final class EmbeddedAssetCreatorV2 {
    EmbeddedAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModel gltfModel) {
        GlTF outputGltf = GltfCreatorV2.create(gltfModel);
        List<Buffer> buffers = Optionals.of(outputGltf.getBuffers());
        List<BufferModel> bufferModels = gltfModel.getBufferModels();
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = buffers.get(i);
            BufferModel bufferModel = bufferModels.get(i);
            String dataUri = DataUris.createBufferDataUri(bufferModel);
            buffer.setUri(dataUri);
        }
        List<Image> images = Optionals.of(outputGltf.getImages());
        List<ImageModel> imageModels = gltfModel.getImageModels();
        for (int i = 0; i < images.size(); ++i) {
            Image image = images.get(i);
            ImageModel imageModel = imageModels.get(i);
            if (imageModel.getBufferViewModel() == null) {
                String currentUri = image.getUri();
                String dataUri = DataUris.createImageDataUri(currentUri, imageModel);
                image.setUri(dataUri);
                continue;
            }
            image.setUri(null);
        }
        return new GltfAssetV2(outputGltf, null);
    }
}

