/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v2;

import com.voxelbridge.shadow.jgltf.impl.v2.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v2.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v2.Image;
import com.voxelbridge.shadow.jgltf.model.Optionals;
import com.voxelbridge.shadow.jgltf.model.io.Buffers;
import com.voxelbridge.shadow.jgltf.model.io.GltfAsset;
import com.voxelbridge.shadow.jgltf.model.io.GltfReference;
import com.voxelbridge.shadow.jgltf.model.io.IO;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class GltfAssetV2
implements GltfAsset {
    private final GlTF gltf;
    private final ByteBuffer binaryData;
    private final Map<String, ByteBuffer> referenceDatas;

    public GltfAssetV2(GlTF gltf, ByteBuffer binaryData) {
        this.gltf = Objects.requireNonNull(gltf, "The gltf may not be null");
        this.binaryData = binaryData;
        this.referenceDatas = new ConcurrentHashMap<String, ByteBuffer>();
    }

    void putReferenceData(String uriString, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this.referenceDatas.remove(uriString);
        } else {
            this.referenceDatas.put(uriString, byteBuffer);
        }
    }

    @Override
    public GlTF getGltf() {
        return this.gltf;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return Buffers.createSlice(this.binaryData);
    }

    @Override
    public List<GltfReference> getReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        references.addAll(this.getBufferReferences());
        references.addAll(this.getImageReferences());
        return references;
    }

    public List<GltfReference> getBufferReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        List<Buffer> buffers = Optionals.of(this.gltf.getBuffers());
        for (int i = 0; i < buffers.size(); ++i) {
            String uri;
            Buffer buffer = buffers.get(i);
            if (buffer.getUri() == null || IO.isDataUriString(uri = buffer.getUri())) continue;
            Consumer<ByteBuffer> target = byteBuffer -> this.putReferenceData(uri, (ByteBuffer)byteBuffer);
            GltfReference reference = new GltfReference("buffer " + i, uri, target);
            references.add(reference);
        }
        return references;
    }

    public List<GltfReference> getImageReferences() {
        ArrayList<GltfReference> references = new ArrayList<GltfReference>();
        List<Image> images = Optionals.of(this.gltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            String uri;
            Image image = images.get(i);
            if (image.getBufferView() != null || IO.isDataUriString(uri = image.getUri())) continue;
            Consumer<ByteBuffer> target = byteBuffer -> this.putReferenceData(uri, (ByteBuffer)byteBuffer);
            GltfReference reference = new GltfReference("image " + i, uri, target);
            references.add(reference);
        }
        return references;
    }

    @Override
    public ByteBuffer getReferenceData(String uriString) {
        return Buffers.createSlice(this.referenceDatas.get(uriString));
    }

    @Override
    public Map<String, ByteBuffer> getReferenceDatas() {
        return Collections.unmodifiableMap(this.referenceDatas);
    }
}

