/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.io.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxelbridge.shadow.jgltf.impl.v2.BufferView;
import com.voxelbridge.shadow.jgltf.impl.v2.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v2.Image;
import com.voxelbridge.shadow.jgltf.model.GltfException;
import com.voxelbridge.shadow.jgltf.model.io.JacksonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class GltfUtilsV2 {
    static GlTF copy(GlTF gltf) {
        ObjectMapper objectMapper = JacksonUtils.createObjectMapper();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            objectMapper.writeValue(baos, (Object)gltf);
            return objectMapper.readValue(baos.toByteArray(), GlTF.class);
        }
        catch (IOException e) {
            throw new GltfException("Could not copy glTF", e);
        }
    }

    static BufferView copy(BufferView bufferView) {
        BufferView copy = new BufferView();
        copy.setExtensions(bufferView.getExtensions());
        copy.setExtras(bufferView.getExtras());
        copy.setName(bufferView.getName());
        copy.setBuffer(bufferView.getBuffer());
        copy.setByteOffset(bufferView.getByteOffset());
        copy.setByteLength(bufferView.getByteLength());
        copy.setTarget(bufferView.getTarget());
        copy.setByteStride(bufferView.getByteStride());
        return copy;
    }

    static Image copy(Image image) {
        Image copy = new Image();
        copy.setExtensions(image.getExtensions());
        copy.setExtras(image.getExtras());
        copy.setName(image.getName());
        copy.setUri(image.getUri());
        copy.setBufferView(image.getBufferView());
        copy.setMimeType(image.getMimeType());
        return copy;
    }

    private GltfUtilsV2() {
    }
}

