/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.structure;

import com.voxelbridge.shadow.jgltf.model.AccessorModel;

class Alignment {
    static int computeAlignmentBytes(AccessorModel accessorModel) {
        return accessorModel.getComponentSizeInBytes();
    }

    static int computeAlignmentBytes(Iterable<? extends AccessorModel> accessorModels) {
        int alignmentBytes = 1;
        for (AccessorModel accessorModel : accessorModels) {
            alignmentBytes = Alignment.computeLeastCommonMultiple(alignmentBytes, Alignment.computeAlignmentBytes(accessorModel));
        }
        return alignmentBytes;
    }

    private static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = 1;
        for (AccessorModel accessorModel : accessorModels) {
            int elementSize = accessorModel.getPaddedElementSizeInBytes();
            commonByteStride = Math.max(commonByteStride, elementSize);
            int byteStride = accessorModel.getByteStride();
            commonByteStride = Math.max(commonByteStride, byteStride);
        }
        return commonByteStride;
    }

    static int computeCommonVertexAttributeByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = Alignment.computeCommonByteStride(accessorModels);
        return Alignment.pad(commonByteStride, 4);
    }

    private static int computeGreatestCommonDivisor(int a, int b) {
        return b == 0 ? a : Alignment.computeGreatestCommonDivisor(b, a % b);
    }

    private static int computeLeastCommonMultiple(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return a * b / Alignment.computeGreatestCommonDivisor(a, b);
    }

    static int computePadding(int size, int alignment) {
        int remainder = size % alignment;
        if (remainder > 0) {
            return alignment - remainder;
        }
        return 0;
    }

    static int pad(int size, int alignment) {
        return size + Alignment.computePadding(size, alignment);
    }

    private Alignment() {
    }
}

