/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.structure;

import com.voxelbridge.shadow.jgltf.impl.v2.Accessor;
import com.voxelbridge.shadow.jgltf.impl.v2.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v2.BufferView;
import com.voxelbridge.shadow.jgltf.model.AccessorModel;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultAccessorModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultBufferModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultBufferViewModel;
import com.voxelbridge.shadow.jgltf.model.structure.BufferStructure;
import com.voxelbridge.shadow.jgltf.model.v2.GltfCreatorV2;
import java.util.ArrayList;
import java.util.List;

public class BufferStructureGltfV2 {
    public static List<Accessor> createAccessors(BufferStructure bufferStructure) {
        List<DefaultAccessorModel> accessorModels = bufferStructure.getAccessorModels();
        ArrayList<Accessor> accessors = new ArrayList<Accessor>();
        for (AccessorModel accessorModel : accessorModels) {
            BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
            int bufferViewIndex = bufferStructure.getBufferViewIndex(bufferViewModel);
            accessors.add(GltfCreatorV2.createAccessor(accessorModel, bufferViewIndex));
        }
        return accessors;
    }

    public static List<BufferView> createBufferViews(BufferStructure bufferStructure) {
        List<DefaultBufferViewModel> bufferViewModels = bufferStructure.getBufferViewModels();
        ArrayList<BufferView> bufferViews = new ArrayList<BufferView>();
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            BufferModel bufferModel = bufferViewModel.getBufferModel();
            int bufferIndex = bufferStructure.getBufferIndex(bufferModel);
            bufferViews.add(GltfCreatorV2.createBufferView(bufferViewModel, bufferIndex));
        }
        return bufferViews;
    }

    public static List<Buffer> createBuffers(BufferStructure bufferStructure) {
        List<DefaultBufferModel> bufferModels = bufferStructure.getBufferModels();
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        for (BufferModel bufferModel : bufferModels) {
            buffers.add(GltfCreatorV2.createBuffer(bufferModel));
        }
        return buffers;
    }

    private BufferStructureGltfV2() {
    }
}

