/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.v1;

import com.voxelbridge.shadow.jgltf.impl.v1.Accessor;
import com.voxelbridge.shadow.jgltf.impl.v1.Animation;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationChannel;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationChannelTarget;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationSampler;
import com.voxelbridge.shadow.jgltf.impl.v1.Asset;
import com.voxelbridge.shadow.jgltf.impl.v1.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v1.BufferView;
import com.voxelbridge.shadow.jgltf.impl.v1.Camera;
import com.voxelbridge.shadow.jgltf.impl.v1.CameraOrthographic;
import com.voxelbridge.shadow.jgltf.impl.v1.CameraPerspective;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTFChildOfRootProperty;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTFProperty;
import com.voxelbridge.shadow.jgltf.impl.v1.Image;
import com.voxelbridge.shadow.jgltf.impl.v1.Material;
import com.voxelbridge.shadow.jgltf.impl.v1.Mesh;
import com.voxelbridge.shadow.jgltf.impl.v1.MeshPrimitive;
import com.voxelbridge.shadow.jgltf.impl.v1.Node;
import com.voxelbridge.shadow.jgltf.impl.v1.Program;
import com.voxelbridge.shadow.jgltf.impl.v1.Sampler;
import com.voxelbridge.shadow.jgltf.impl.v1.Scene;
import com.voxelbridge.shadow.jgltf.impl.v1.Shader;
import com.voxelbridge.shadow.jgltf.impl.v1.Skin;
import com.voxelbridge.shadow.jgltf.impl.v1.Technique;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueParameters;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStates;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStatesFunctions;
import com.voxelbridge.shadow.jgltf.impl.v1.Texture;
import com.voxelbridge.shadow.jgltf.model.AccessorData;
import com.voxelbridge.shadow.jgltf.model.AccessorDatas;
import com.voxelbridge.shadow.jgltf.model.AccessorModel;
import com.voxelbridge.shadow.jgltf.model.AnimationModel;
import com.voxelbridge.shadow.jgltf.model.AssetModel;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.CameraModel;
import com.voxelbridge.shadow.jgltf.model.CameraOrthographicModel;
import com.voxelbridge.shadow.jgltf.model.CameraPerspectiveModel;
import com.voxelbridge.shadow.jgltf.model.ExtensionsModel;
import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.ImageModel;
import com.voxelbridge.shadow.jgltf.model.MaterialModel;
import com.voxelbridge.shadow.jgltf.model.MeshModel;
import com.voxelbridge.shadow.jgltf.model.MeshPrimitiveModel;
import com.voxelbridge.shadow.jgltf.model.ModelElement;
import com.voxelbridge.shadow.jgltf.model.NamedModelElement;
import com.voxelbridge.shadow.jgltf.model.NodeModel;
import com.voxelbridge.shadow.jgltf.model.Optionals;
import com.voxelbridge.shadow.jgltf.model.SceneModel;
import com.voxelbridge.shadow.jgltf.model.SkinModel;
import com.voxelbridge.shadow.jgltf.model.TextureModel;
import com.voxelbridge.shadow.jgltf.model.gl.ProgramModel;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueParametersModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueStatesFunctionsModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueStatesModel;
import com.voxelbridge.shadow.jgltf.model.v1.BinaryGltfV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import com.voxelbridge.shadow.jgltf.model.v1.MaterialModelV1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GltfCreatorV1 {
    private static final Logger logger = Logger.getLogger(GltfCreatorV1.class.getName());
    private final GltfModel gltfModel;
    private final Map<AccessorModel, String> accessorIds;
    private final Map<BufferModel, String> bufferIds;
    private final Map<BufferViewModel, String> bufferViewIds;
    private final Map<CameraModel, String> cameraIds;
    private final Map<ImageModel, String> imageIds;
    private final Map<MaterialModel, String> materialIds;
    private final Map<MeshModel, String> meshIds;
    private final Map<NodeModel, String> nodeIds;
    private final Map<ProgramModel, String> programIds;
    private final Map<ShaderModel, String> shaderIds;
    private final Map<SkinModel, String> skinIds;
    private final Map<TechniqueModel, String> techniqueIds;
    private final Map<TextureModel, String> textureIds;
    private final Map<SamplerInfo, String> samplerIds;

    public static GlTF create(GltfModel gltfModel) {
        GltfCreatorV1 creator = new GltfCreatorV1(gltfModel);
        return creator.create();
    }

    private GltfCreatorV1(GltfModel gltfModel) {
        this.gltfModel = Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.accessorIds = GltfCreatorV1.computeIdMap("accessor", gltfModel.getAccessorModels());
        this.bufferIds = GltfCreatorV1.computeIdMap("buffer", gltfModel.getBufferModels());
        this.bufferViewIds = GltfCreatorV1.computeIdMap("bufferView", gltfModel.getBufferViewModels());
        this.cameraIds = GltfCreatorV1.computeIdMap("camera", gltfModel.getCameraModels());
        this.imageIds = GltfCreatorV1.computeIdMap("image", gltfModel.getImageModels());
        this.materialIds = GltfCreatorV1.computeIdMap("material", gltfModel.getMaterialModels());
        this.meshIds = GltfCreatorV1.computeIdMap("mesh", gltfModel.getMeshModels());
        this.nodeIds = GltfCreatorV1.computeIdMap("node", gltfModel.getNodeModels());
        this.skinIds = GltfCreatorV1.computeIdMap("skin", gltfModel.getSkinModels());
        this.textureIds = GltfCreatorV1.computeIdMap("texture", gltfModel.getTextureModels());
        if (gltfModel instanceof GltfModelV1) {
            GltfModelV1 gltfModelV1 = (GltfModelV1)gltfModel;
            this.programIds = GltfCreatorV1.computeIdMap("program", gltfModelV1.getProgramModels());
            this.shaderIds = GltfCreatorV1.computeIdMap("shader", gltfModelV1.getShaderModels());
            this.techniqueIds = GltfCreatorV1.computeIdMap("technique", gltfModelV1.getTechniqueModels());
        } else {
            this.programIds = Collections.emptyMap();
            this.shaderIds = Collections.emptyMap();
            this.techniqueIds = Collections.emptyMap();
        }
        this.samplerIds = this.createSamplerIds(gltfModel.getTextureModels());
    }

    public GlTF create() {
        ExtensionsModel extensionsModel;
        List<String> extensionsUsed;
        GlTF gltf = new GlTF();
        GltfCreatorV1.transferGltfPropertyElements(this.gltfModel, gltf);
        gltf.setAccessors(GltfCreatorV1.map("accessor", this.gltfModel.getAccessorModels(), this::createAccessor));
        gltf.setAnimations(GltfCreatorV1.map("animation", this.gltfModel.getAnimationModels(), this::createAnimation));
        gltf.setBuffers(GltfCreatorV1.map("buffer", this.gltfModel.getBufferModels(), GltfCreatorV1::createBuffer));
        gltf.setBufferViews(GltfCreatorV1.map("bufferView", this.gltfModel.getBufferViewModels(), this::createBufferView));
        gltf.setCameras(GltfCreatorV1.map("camera", this.gltfModel.getCameraModels(), this::createCamera));
        gltf.setImages(GltfCreatorV1.map("image", this.gltfModel.getImageModels(), this::createImage));
        gltf.setMaterials(GltfCreatorV1.map("material", this.gltfModel.getMaterialModels(), this::createMaterial));
        gltf.setMeshes(GltfCreatorV1.map("mesh", this.gltfModel.getMeshModels(), this::createMesh));
        gltf.setNodes(GltfCreatorV1.map("node", this.gltfModel.getNodeModels(), this::createNode));
        gltf.setScenes(GltfCreatorV1.map("scene", this.gltfModel.getSceneModels(), this::createScene));
        gltf.setSkins(GltfCreatorV1.map("skin", this.gltfModel.getSkinModels(), this::createSkin));
        gltf.setSamplers(this.createSamplers());
        gltf.setTextures(GltfCreatorV1.map("texture", this.gltfModel.getTextureModels(), this::createTexture));
        if (this.gltfModel instanceof GltfModelV1) {
            GltfModelV1 gltfModelV1 = (GltfModelV1)this.gltfModel;
            gltf.setPrograms(GltfCreatorV1.map("program", gltfModelV1.getProgramModels(), this::createProgram));
            gltf.setShaders(GltfCreatorV1.map("shader", gltfModelV1.getShaderModels(), this::createShader));
            gltf.setTechniques(GltfCreatorV1.map("technique", gltfModelV1.getTechniqueModels(), this::createTechnique));
        }
        if (gltf.getScenes() != null && !gltf.getScenes().isEmpty()) {
            gltf.setScene(gltf.getScenes().keySet().iterator().next());
        }
        if (!(extensionsUsed = (extensionsModel = this.gltfModel.getExtensionsModel()).getExtensionsUsed()).isEmpty()) {
            gltf.setExtensionsUsed(extensionsUsed);
        }
        Asset asset = this.createAsset(this.gltfModel.getAssetModel());
        gltf.setAsset(asset);
        return gltf;
    }

    private Accessor createAccessor(AccessorModel accessorModel) {
        String bufferViewId = this.bufferViewIds.get(accessorModel.getBufferViewModel());
        return GltfCreatorV1.createAccessor(accessorModel, bufferViewId);
    }

    public static Accessor createAccessor(AccessorModel accessorModel, String bufferViewId) {
        Accessor accessor = new Accessor();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(accessorModel, accessor);
        accessor.setBufferView(bufferViewId);
        accessor.setByteOffset(accessorModel.getByteOffset());
        accessor.setComponentType(accessorModel.getComponentType());
        accessor.setCount(accessorModel.getCount());
        accessor.setType(accessorModel.getElementType().toString());
        accessor.setByteStride(accessorModel.getByteStride());
        AccessorData accessorData = accessorModel.getAccessorData();
        accessor.setMax(AccessorDatas.computeMax(accessorData));
        accessor.setMin(AccessorDatas.computeMin(accessorData));
        return accessor;
    }

    private Animation createAnimation(AnimationModel animationModel) {
        Animation animation = new Animation();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(animationModel, animation);
        LinkedHashMap<AnimationModel.Sampler, String> samplers = new LinkedHashMap<AnimationModel.Sampler, String>();
        List<AnimationModel.Channel> channels = animationModel.getChannels();
        int counter = 0;
        for (AnimationModel.Channel channel : channels) {
            String id = "sampler_" + counter;
            samplers.put(channel.getSampler(), id);
            ++counter;
        }
        ArrayList<AnimationChannel> animationChannels = new ArrayList<AnimationChannel>();
        for (AnimationModel.Channel channel : channels) {
            AnimationChannel animationChannel = new AnimationChannel();
            AnimationChannelTarget target = new AnimationChannelTarget();
            NodeModel nodeModel = channel.getNodeModel();
            target.setId(this.nodeIds.get(nodeModel));
            target.setPath(channel.getPath());
            animationChannel.setTarget(target);
            AnimationModel.Sampler sampler = channel.getSampler();
            animationChannel.setSampler((String)samplers.get(sampler));
            animationChannels.add(animationChannel);
        }
        animation.setChannels(animationChannels);
        LinkedHashMap<String, AnimationSampler> linkedHashMap = new LinkedHashMap<String, AnimationSampler>();
        for (AnimationModel.Sampler sampler : samplers.keySet()) {
            AnimationSampler animationSampler = new AnimationSampler();
            animationSampler.setInput(this.accessorIds.get(sampler.getInput()));
            animationSampler.setInterpolation(sampler.getInterpolation().name());
            animationSampler.setOutput(this.accessorIds.get(sampler.getOutput()));
            String key = (String)samplers.get(sampler);
            linkedHashMap.put(key, animationSampler);
        }
        animation.setSamplers(linkedHashMap);
        return animation;
    }

    public static Buffer createBuffer(BufferModel bufferModel) {
        Buffer buffer = new Buffer();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(bufferModel, buffer);
        buffer.setUri(bufferModel.getUri());
        buffer.setByteLength(bufferModel.getByteLength());
        return buffer;
    }

    private BufferView createBufferView(BufferViewModel bufferViewModel) {
        String bufferId = this.bufferIds.get(bufferViewModel.getBufferModel());
        return GltfCreatorV1.createBufferView(bufferViewModel, bufferId);
    }

    public static BufferView createBufferView(BufferViewModel bufferViewModel, String bufferId) {
        BufferView bufferView = new BufferView();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(bufferViewModel, bufferView);
        bufferView.setBuffer(bufferId);
        bufferView.setByteOffset(bufferViewModel.getByteOffset());
        bufferView.setByteLength(bufferViewModel.getByteLength());
        bufferView.setTarget(bufferViewModel.getTarget());
        return bufferView;
    }

    private Camera createCamera(CameraModel cameraModel) {
        Camera camera = new Camera();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(cameraModel, camera);
        CameraPerspectiveModel cameraPerspectiveModel = cameraModel.getCameraPerspectiveModel();
        CameraOrthographicModel cameraOrthographicModel = cameraModel.getCameraOrthographicModel();
        if (cameraPerspectiveModel != null) {
            CameraPerspective cameraPerspective = new CameraPerspective();
            cameraPerspective.setAspectRatio(cameraPerspectiveModel.getAspectRatio());
            cameraPerspective.setYfov(cameraPerspectiveModel.getYfov());
            cameraPerspective.setZfar(cameraPerspectiveModel.getZfar());
            cameraPerspective.setZnear(cameraPerspectiveModel.getZnear());
            camera.setPerspective(cameraPerspective);
            camera.setType("perspective");
        } else if (cameraOrthographicModel != null) {
            CameraOrthographic cameraOrthographic = new CameraOrthographic();
            cameraOrthographic.setXmag(cameraOrthographicModel.getXmag());
            cameraOrthographic.setYmag(cameraOrthographicModel.getYmag());
            cameraOrthographic.setZfar(cameraOrthographicModel.getZfar());
            cameraOrthographic.setZnear(cameraOrthographicModel.getZnear());
            camera.setOrthographic(cameraOrthographic);
            camera.setType("orthographic");
        } else {
            logger.severe("Camera is neither perspective nor orthographic");
        }
        return camera;
    }

    private Image createImage(ImageModel imageModel) {
        Image image = new Image();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(imageModel, image);
        String bufferView = this.bufferViewIds.get(imageModel.getBufferViewModel());
        if (bufferView != null) {
            BinaryGltfV1.setBinaryGltfBufferViewId(image, bufferView);
        } else {
            image.setUri(imageModel.getUri());
        }
        return image;
    }

    private Material createMaterial(MaterialModel materialModel) {
        if (materialModel instanceof MaterialModelV1) {
            MaterialModelV1 materialModelV1 = (MaterialModelV1)materialModel;
            return this.createMaterialV1(materialModelV1);
        }
        logger.severe("Cannot store glTF 2.0 material in glTF 1.0");
        return null;
    }

    private Material createMaterialV1(MaterialModelV1 materialModel) {
        Material material = new Material();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(materialModel, material);
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        material.setTechnique(this.techniqueIds.get(techniqueModel));
        Map<String, Object> modelValues = materialModel.getValues();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> valueEntry : modelValues.entrySet()) {
            String parameterName = valueEntry.getKey();
            Object value = valueEntry.getValue();
            if (value instanceof TextureModel) {
                TextureModel textureModel = (TextureModel)value;
                String textureId = this.textureIds.get(textureModel);
                values.put(parameterName, textureId);
                continue;
            }
            values.put(parameterName, value);
        }
        material.setValues(values);
        return material;
    }

    private Program createProgram(ProgramModel programModel) {
        Program program = new Program();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(programModel, program);
        ShaderModel vertexShaderModel = programModel.getVertexShaderModel();
        program.setVertexShader(this.shaderIds.get(vertexShaderModel));
        ShaderModel fragmentShaderModel = programModel.getFragmentShaderModel();
        program.setFragmentShader(this.shaderIds.get(fragmentShaderModel));
        List<String> modelAttributes = programModel.getAttributes();
        if (!modelAttributes.isEmpty()) {
            ArrayList<String> attributes = new ArrayList<String>(modelAttributes);
            program.setAttributes(attributes);
        }
        return program;
    }

    private Shader createShader(ShaderModel shaderModel) {
        Shader shader = new Shader();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(shaderModel, shader);
        ShaderModel.ShaderType shaderType = shaderModel.getShaderType();
        if (shaderType == ShaderModel.ShaderType.VERTEX_SHADER) {
            shader.setType(35633);
        } else if (shaderType == ShaderModel.ShaderType.FRAGMENT_SHADER) {
            shader.setType(35632);
        } else {
            logger.severe("Invalid shader type: " + (Object)((Object)shaderType));
        }
        shader.setUri(shaderModel.getUri());
        return shader;
    }

    private Technique createTechnique(TechniqueModel techniqueModel) {
        Technique technique = new Technique();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(techniqueModel, technique);
        ProgramModel programModel = techniqueModel.getProgramModel();
        technique.setProgram(this.programIds.get(programModel));
        Map<String, String> uniforms = techniqueModel.getUniforms();
        technique.setUniforms(new LinkedHashMap<String, String>(uniforms));
        Map<String, String> attributes = techniqueModel.getAttributes();
        technique.setAttributes(new LinkedHashMap<String, String>(attributes));
        Map<String, TechniqueParametersModel> parametersModel = techniqueModel.getParameters();
        if (!parametersModel.isEmpty()) {
            LinkedHashMap<String, TechniqueParameters> parameters = new LinkedHashMap<String, TechniqueParameters>();
            for (Map.Entry<String, TechniqueParametersModel> entry : parametersModel.entrySet()) {
                String key = entry.getKey();
                TechniqueParametersModel techniqueParametersModel = entry.getValue();
                TechniqueParameters techniqueParameters = this.createTechniqueParameters(techniqueParametersModel);
                parameters.put(key, techniqueParameters);
            }
            technique.setParameters(parameters);
        }
        technique.setStates(this.createTechniqueStates(techniqueModel.getTechniqueStatesModel()));
        return technique;
    }

    private TechniqueParameters createTechniqueParameters(TechniqueParametersModel techniqueParametersModel) {
        TechniqueParameters techniqueParameters = new TechniqueParameters();
        techniqueParameters.setSemantic(techniqueParametersModel.getSemantic());
        techniqueParameters.setType(techniqueParametersModel.getType());
        techniqueParameters.setCount(techniqueParametersModel.getCount());
        techniqueParameters.setValue(techniqueParametersModel.getValue());
        NodeModel nodeModel = techniqueParametersModel.getNodeModel();
        techniqueParameters.setNode(this.nodeIds.get(nodeModel));
        return techniqueParameters;
    }

    private TechniqueStates createTechniqueStates(TechniqueStatesModel techniqueStatesModel) {
        if (techniqueStatesModel == null) {
            return null;
        }
        TechniqueStates techniqueStates = new TechniqueStates();
        List<Integer> enable = techniqueStatesModel.getEnable();
        if (enable != null) {
            techniqueStates.setEnable(new ArrayList<Integer>(enable));
        }
        techniqueStates.setFunctions(this.createTechniqueStatesFunctions(techniqueStatesModel.getTechniqueStatesFunctionsModel()));
        return techniqueStates;
    }

    private TechniqueStatesFunctions createTechniqueStatesFunctions(TechniqueStatesFunctionsModel techniqueStatesFunctionsModel) {
        if (techniqueStatesFunctionsModel == null) {
            return null;
        }
        TechniqueStatesFunctions techniqueStatesFunctions = new TechniqueStatesFunctions();
        techniqueStatesFunctions.setBlendColor(Optionals.clone(techniqueStatesFunctionsModel.getBlendColor()));
        techniqueStatesFunctions.setBlendEquationSeparate(Optionals.clone(techniqueStatesFunctionsModel.getBlendEquationSeparate()));
        techniqueStatesFunctions.setBlendFuncSeparate(Optionals.clone(techniqueStatesFunctionsModel.getBlendFuncSeparate()));
        techniqueStatesFunctions.setColorMask(Optionals.clone(techniqueStatesFunctionsModel.getColorMask()));
        techniqueStatesFunctions.setCullFace(Optionals.clone(techniqueStatesFunctionsModel.getCullFace()));
        techniqueStatesFunctions.setDepthFunc(Optionals.clone(techniqueStatesFunctionsModel.getDepthFunc()));
        techniqueStatesFunctions.setDepthMask(Optionals.clone(techniqueStatesFunctionsModel.getDepthMask()));
        techniqueStatesFunctions.setDepthRange(Optionals.clone(techniqueStatesFunctionsModel.getDepthRange()));
        techniqueStatesFunctions.setFrontFace(Optionals.clone(techniqueStatesFunctionsModel.getFrontFace()));
        techniqueStatesFunctions.setLineWidth(Optionals.clone(techniqueStatesFunctionsModel.getLineWidth()));
        techniqueStatesFunctions.setPolygonOffset(Optionals.clone(techniqueStatesFunctionsModel.getPolygonOffset()));
        return techniqueStatesFunctions;
    }

    private Mesh createMesh(MeshModel meshModel) {
        Mesh mesh = new Mesh();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(meshModel, mesh);
        ArrayList<MeshPrimitive> meshPrimitives = new ArrayList<MeshPrimitive>();
        List<MeshPrimitiveModel> meshPrimitiveModels = meshModel.getMeshPrimitiveModels();
        for (MeshPrimitiveModel meshPrimitiveModel : meshPrimitiveModels) {
            MeshPrimitive meshPrimitive = this.createMeshPrimitive(meshPrimitiveModel);
            meshPrimitives.add(meshPrimitive);
        }
        mesh.setPrimitives(meshPrimitives);
        if (meshModel.getWeights() != null) {
            logger.severe("Morph target weights are not supported in glTF 1.0");
        }
        return mesh;
    }

    private MeshPrimitive createMeshPrimitive(MeshPrimitiveModel meshPrimitiveModel) {
        MeshPrimitive meshPrimitive = new MeshPrimitive();
        GltfCreatorV1.transferGltfPropertyElements(meshPrimitiveModel, meshPrimitive);
        meshPrimitive.setMode(meshPrimitiveModel.getMode());
        Map<String, String> attributes = GltfCreatorV1.resolveIds(meshPrimitiveModel.getAttributes(), this.accessorIds::get);
        meshPrimitive.setAttributes(attributes);
        AccessorModel Ids = meshPrimitiveModel.getIndices();
        meshPrimitive.setIndices(this.accessorIds.get(Ids));
        List<Map<String, AccessorModel>> modelTargetsList = meshPrimitiveModel.getTargets();
        if (!modelTargetsList.isEmpty()) {
            logger.severe("Morph targets are not supported in glTF 1.0");
        }
        String material = this.materialIds.get(meshPrimitiveModel.getMaterialModel());
        meshPrimitive.setMaterial(material);
        return meshPrimitive;
    }

    private Node createNode(NodeModel nodeModel) {
        List<MeshModel> nodeMeshModels;
        Node node = new Node();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(nodeModel, node);
        if (!nodeModel.getChildren().isEmpty()) {
            node.setChildren(GltfCreatorV1.map(nodeModel.getChildren(), this.nodeIds::get));
        }
        node.setTranslation(Optionals.clone(nodeModel.getTranslation()));
        node.setRotation(Optionals.clone(nodeModel.getRotation()));
        node.setScale(Optionals.clone(nodeModel.getScale()));
        node.setMatrix(Optionals.clone(nodeModel.getMatrix()));
        String camera = this.cameraIds.get(nodeModel.getCameraModel());
        node.setCamera(camera);
        String skin = this.skinIds.get(nodeModel.getSkinModel());
        node.setSkin(skin);
        if (nodeModel.getWeights() != null) {
            logger.severe("Morph target weights are not supported in glTF 1.0");
        }
        if (!(nodeMeshModels = nodeModel.getMeshModels()).isEmpty()) {
            ArrayList<String> meshes = new ArrayList<String>();
            for (MeshModel meshModel : nodeMeshModels) {
                String id = this.meshIds.get(meshModel);
                meshes.add(id);
            }
            node.setMeshes(meshes);
        }
        return node;
    }

    private Scene createScene(SceneModel sceneModel) {
        Scene scene = new Scene();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(sceneModel, scene);
        scene.setNodes(GltfCreatorV1.map(sceneModel.getNodeModels(), this.nodeIds::get));
        return scene;
    }

    private Skin createSkin(SkinModel skinModel) {
        Skin skin = new Skin();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(skinModel, skin);
        String inverseBindMatrices = this.accessorIds.get(skinModel.getInverseBindMatrices());
        skin.setInverseBindMatrices(inverseBindMatrices);
        logger.severe("Skins are not yet fully supported");
        return skin;
    }

    private Map<SamplerInfo, String> createSamplerIds(List<TextureModel> textureModels) {
        LinkedHashMap<SamplerInfo, String> samplerIndices = new LinkedHashMap<SamplerInfo, String>();
        for (TextureModel textureModel : textureModels) {
            SamplerInfo samplerInfo = new SamplerInfo(textureModel);
            if (samplerIndices.containsKey(samplerInfo)) continue;
            samplerIndices.put(samplerInfo, "sampler_" + samplerIndices.size());
        }
        return samplerIndices;
    }

    private Map<String, Sampler> createSamplers() {
        if (this.samplerIds.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Sampler> samplers = new LinkedHashMap<String, Sampler>();
        for (SamplerInfo samplerInfo : this.samplerIds.keySet()) {
            Sampler sampler = GltfCreatorV1.createSampler(samplerInfo);
            String key = this.samplerIds.get(samplerInfo);
            samplers.put(key, sampler);
        }
        return samplers;
    }

    private static Sampler createSampler(SamplerInfo samplerInfo) {
        Sampler sampler = new Sampler();
        sampler.setMagFilter(samplerInfo.magFilter);
        sampler.setMinFilter(samplerInfo.minFilter);
        sampler.setWrapS(samplerInfo.wrapS);
        sampler.setWrapT(samplerInfo.wrapT);
        return sampler;
    }

    private Texture createTexture(TextureModel textureModel) {
        Texture texture = new Texture();
        GltfCreatorV1.transferGltfChildOfRootPropertyElements(textureModel, texture);
        SamplerInfo samplerInfo = new SamplerInfo(textureModel);
        String id = this.samplerIds.get(samplerInfo);
        texture.setSampler(id);
        texture.setSource(this.imageIds.get(textureModel.getImageModel()));
        return texture;
    }

    private Asset createAsset(AssetModel assetModel) {
        Asset asset = new Asset();
        asset.setVersion("1.0");
        asset.setGenerator("JglTF from https://github.com/javagl/JglTF");
        GltfCreatorV1.transferGltfPropertyElements(assetModel, asset);
        if (assetModel.getCopyright() != null) {
            asset.setCopyright(assetModel.getCopyright());
        }
        if (assetModel.getGenerator() != null) {
            asset.setGenerator(assetModel.getGenerator());
        }
        return asset;
    }

    private static void transferGltfPropertyElements(ModelElement modelElement, GlTFProperty property) {
        property.setExtensions(modelElement.getExtensions());
        property.setExtras(modelElement.getExtras());
    }

    private static void transferGltfChildOfRootPropertyElements(NamedModelElement modelElement, GlTFChildOfRootProperty property) {
        property.setName(modelElement.getName());
        GltfCreatorV1.transferGltfPropertyElements(modelElement, property);
    }

    private static <T, U> Map<String, U> map(String prefix, Collection<? extends T> elements, Function<? super T, ? extends U> mapper) {
        return GltfCreatorV1.map(prefix, GltfCreatorV1.map(elements, mapper));
    }

    private static <T> Map<String, T> map(String prefix, Collection<? extends T> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        int index = 0;
        for (T element : elements) {
            map.put(prefix + "_" + index, element);
            ++index;
        }
        return map;
    }

    private static <T, U> List<U> map(Collection<? extends T> collection, Function<? super T, ? extends U> mapper) {
        if (collection.isEmpty()) {
            return null;
        }
        return collection.stream().map(mapper).collect(Collectors.toList());
    }

    private static <K, T> Map<K, String> resolveIds(Map<K, ? extends T> map, Function<? super T, String> idLookup) {
        LinkedHashMap<K, String> result = new LinkedHashMap<K, String>();
        for (Map.Entry<K, T> entry : map.entrySet()) {
            K key = entry.getKey();
            T value = entry.getValue();
            String id = idLookup.apply(value);
            result.put(key, id);
        }
        return result;
    }

    private static <T> Map<T, String> computeIdMap(String prefix, Collection<? extends T> elements) {
        LinkedHashMap<T, String> ids = new LinkedHashMap<T, String>();
        int index = 0;
        for (T element : elements) {
            ids.put(element, prefix + "_" + index);
            ++index;
        }
        return ids;
    }

    private static class SamplerInfo {
        final Integer magFilter;
        final Integer minFilter;
        final Integer wrapS;
        final Integer wrapT;

        SamplerInfo(TextureModel textureModel) {
            this.magFilter = textureModel.getMagFilter();
            this.minFilter = textureModel.getMinFilter();
            this.wrapS = textureModel.getWrapS();
            this.wrapT = textureModel.getWrapT();
        }

        public int hashCode() {
            return Objects.hash(this.magFilter, this.minFilter, this.wrapS, this.wrapT);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SamplerInfo other = (SamplerInfo)object;
            if (!Objects.equals(this.magFilter, other.magFilter)) {
                return false;
            }
            if (!Objects.equals(this.minFilter, other.minFilter)) {
                return false;
            }
            if (!Objects.equals(this.wrapS, other.wrapS)) {
                return false;
            }
            return Objects.equals(this.wrapT, other.wrapT);
        }
    }
}

