/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.v1;

import com.voxelbridge.shadow.jgltf.impl.v1.Accessor;
import com.voxelbridge.shadow.jgltf.impl.v1.Animation;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationChannel;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationChannelTarget;
import com.voxelbridge.shadow.jgltf.impl.v1.AnimationSampler;
import com.voxelbridge.shadow.jgltf.impl.v1.Asset;
import com.voxelbridge.shadow.jgltf.impl.v1.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v1.BufferView;
import com.voxelbridge.shadow.jgltf.impl.v1.Camera;
import com.voxelbridge.shadow.jgltf.impl.v1.CameraOrthographic;
import com.voxelbridge.shadow.jgltf.impl.v1.CameraPerspective;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTFChildOfRootProperty;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTFProperty;
import com.voxelbridge.shadow.jgltf.impl.v1.Image;
import com.voxelbridge.shadow.jgltf.impl.v1.Material;
import com.voxelbridge.shadow.jgltf.impl.v1.Mesh;
import com.voxelbridge.shadow.jgltf.impl.v1.MeshPrimitive;
import com.voxelbridge.shadow.jgltf.impl.v1.Node;
import com.voxelbridge.shadow.jgltf.impl.v1.Program;
import com.voxelbridge.shadow.jgltf.impl.v1.Sampler;
import com.voxelbridge.shadow.jgltf.impl.v1.Scene;
import com.voxelbridge.shadow.jgltf.impl.v1.Shader;
import com.voxelbridge.shadow.jgltf.impl.v1.Skin;
import com.voxelbridge.shadow.jgltf.impl.v1.Technique;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueParameters;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStates;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStatesFunctions;
import com.voxelbridge.shadow.jgltf.impl.v1.Texture;
import com.voxelbridge.shadow.jgltf.model.AccessorDatas;
import com.voxelbridge.shadow.jgltf.model.AccessorModel;
import com.voxelbridge.shadow.jgltf.model.Accessors;
import com.voxelbridge.shadow.jgltf.model.AnimationModel;
import com.voxelbridge.shadow.jgltf.model.BufferModel;
import com.voxelbridge.shadow.jgltf.model.BufferViewModel;
import com.voxelbridge.shadow.jgltf.model.CameraModel;
import com.voxelbridge.shadow.jgltf.model.ElementType;
import com.voxelbridge.shadow.jgltf.model.MaterialModel;
import com.voxelbridge.shadow.jgltf.model.MeshModel;
import com.voxelbridge.shadow.jgltf.model.NodeModel;
import com.voxelbridge.shadow.jgltf.model.Optionals;
import com.voxelbridge.shadow.jgltf.model.SkinModel;
import com.voxelbridge.shadow.jgltf.model.TextureModel;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueParametersModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultProgramModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultShaderModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultTechniqueModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultTechniqueParametersModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultTechniqueStatesFunctionsModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultTechniqueStatesModel;
import com.voxelbridge.shadow.jgltf.model.impl.AbstractModelElement;
import com.voxelbridge.shadow.jgltf.model.impl.AbstractNamedModelElement;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultAccessorModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultAnimationModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultAssetModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultBufferModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultBufferViewModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultCameraModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultCameraOrthographicModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultCameraPerspectiveModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultExtensionsModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultImageModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultMeshModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultMeshPrimitiveModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultNodeModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultSceneModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultSkinModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultTextureModel;
import com.voxelbridge.shadow.jgltf.model.io.Buffers;
import com.voxelbridge.shadow.jgltf.model.io.GltfAsset;
import com.voxelbridge.shadow.jgltf.model.io.IO;
import com.voxelbridge.shadow.jgltf.model.io.MimeTypes;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.v1.BinaryGltfV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelV1;
import com.voxelbridge.shadow.jgltf.model.v1.IndexMappingSet;
import com.voxelbridge.shadow.jgltf.model.v1.IndexMappingSets;
import com.voxelbridge.shadow.jgltf.model.v1.MaterialModelV1;
import com.voxelbridge.shadow.jgltf.model.v1.gl.DefaultModels;
import com.voxelbridge.shadow.jgltf.model.v1.gl.GltfDefaults;
import com.voxelbridge.shadow.jgltf.model.v1.gl.TechniqueStatesFunctionsModels;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Logger;

public class GltfModelCreatorV1 {
    private static final Logger logger = Logger.getLogger(GltfModelCreatorV1.class.getName());
    private final IndexMappingSet indexMappingSet;
    private final GltfAsset gltfAsset;
    private final GlTF gltf;
    private final GltfModelV1 gltfModel;

    public static GltfModelV1 create(GltfAssetV1 gltfAsset) {
        GltfModelV1 gltfModel = new GltfModelV1();
        GltfModelCreatorV1 creator = new GltfModelCreatorV1(gltfAsset, gltfModel);
        creator.create();
        return gltfModel;
    }

    GltfModelCreatorV1(GltfAssetV1 gltfAsset, GltfModelV1 gltfModel) {
        this.gltfAsset = Objects.requireNonNull(gltfAsset, "The gltfAsset may not be null");
        this.gltf = gltfAsset.getGltf();
        this.gltfModel = Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.indexMappingSet = IndexMappingSets.create(gltfAsset.getGltf());
    }

    void create() {
        GltfModelCreatorV1.transferGltfPropertyElements(this.gltf, this.gltfModel);
        this.createAccessorModels();
        this.createAnimationModels();
        this.createBufferModels();
        this.createBufferViewModels();
        this.createCameraModels();
        this.createImageModels();
        this.createMaterialModels();
        this.createMeshModels();
        this.createNodeModels();
        this.createSceneModels();
        this.createSkinModels();
        this.createTextureModels();
        this.createShaderModels();
        this.createProgramModels();
        this.createTechniqueModels();
        this.initBufferModels();
        this.initBufferViewModels();
        this.initAccessorModels();
        this.assignBufferViewByteStrides();
        this.initAnimationModels();
        this.initImageModels();
        this.initTechniqueModels();
        this.initMaterialModels();
        this.initMeshModels();
        this.initNodeModels();
        this.initSceneModels();
        this.initSkinModels();
        this.initTextureModels();
        this.initShaderModels();
        this.initProgramModels();
        this.initExtensionsModel();
        this.initAssetModel();
    }

    private void createAccessorModels() {
        Map<String, Accessor> accessors = Optionals.of(this.gltf.getAccessors());
        for (Accessor accessor : accessors.values()) {
            DefaultAccessorModel accessorModel = GltfModelCreatorV1.createAccessorModel(accessor);
            this.gltfModel.addAccessorModel(accessorModel);
        }
    }

    private static DefaultAccessorModel createAccessorModel(Accessor accessor) {
        Integer componentType = accessor.getComponentType();
        Integer byteOffset = accessor.getByteOffset();
        Integer count = accessor.getCount();
        ElementType elementType = ElementType.forString(accessor.getType());
        Integer byteStride = accessor.getByteStride();
        if (byteStride == null) {
            byteStride = elementType.getNumComponents() * Accessors.getNumBytesForAccessorComponentType(componentType);
        }
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        accessorModel.setByteOffset(byteOffset);
        accessorModel.setByteStride(byteStride);
        return accessorModel;
    }

    private void createAnimationModels() {
        Map<String, Animation> animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            this.gltfModel.addAnimationModel(new DefaultAnimationModel());
        }
    }

    private void createBufferModels() {
        Map<String, Buffer> buffers = Optionals.of(this.gltf.getBuffers());
        for (Buffer buffer : buffers.values()) {
            DefaultBufferModel bufferModel = new DefaultBufferModel();
            bufferModel.setUri(buffer.getUri());
            this.gltfModel.addBufferModel(bufferModel);
        }
    }

    private void createBufferViewModels() {
        Map<String, BufferView> bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (BufferView bufferView : bufferViews.values()) {
            DefaultBufferViewModel bufferViewModel = GltfModelCreatorV1.createBufferViewModel(bufferView);
            this.gltfModel.addBufferViewModel(bufferViewModel);
        }
    }

    private void createCameraModels() {
        Map<String, Camera> cameras = Optionals.of(this.gltf.getCameras());
        for (Camera camera : cameras.values()) {
            DefaultCameraModel cameraModel;
            String type = camera.getType();
            if ("perspective".equals(type)) {
                CameraPerspective cameraPerspective = camera.getPerspective();
                DefaultCameraPerspectiveModel cameraPerspectiveModel = new DefaultCameraPerspectiveModel();
                cameraPerspectiveModel.setAspectRatio(cameraPerspective.getAspectRatio());
                cameraPerspectiveModel.setYfov(cameraPerspective.getYfov());
                cameraPerspectiveModel.setZfar(cameraPerspective.getZfar());
                cameraPerspectiveModel.setZnear(cameraPerspective.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraPerspectiveModel(cameraPerspectiveModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            if ("orthographic".equals(type)) {
                CameraOrthographic cameraOrthographic = camera.getOrthographic();
                DefaultCameraOrthographicModel cameraOrthographicModel = new DefaultCameraOrthographicModel();
                cameraOrthographicModel.setXmag(cameraOrthographic.getXmag());
                cameraOrthographicModel.setYmag(cameraOrthographic.getYmag());
                cameraOrthographicModel.setZfar(cameraOrthographic.getZfar());
                cameraOrthographicModel.setZnear(cameraOrthographic.getZnear());
                cameraModel = new DefaultCameraModel();
                cameraModel.setCameraOrthographicModel(cameraOrthographicModel);
                this.gltfModel.addCameraModel(cameraModel);
                continue;
            }
            logger.severe("Invalid camera type: " + type);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(BufferView bufferView) {
        int byteOffset = bufferView.getByteOffset();
        Integer byteLength = bufferView.getByteLength();
        if (byteLength == null) {
            logger.warning("No byteLength found in BufferView");
            byteLength = 0;
        }
        Integer target = bufferView.getTarget();
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        bufferViewModel.setByteOffset(byteOffset);
        bufferViewModel.setByteLength(byteLength);
        return bufferViewModel;
    }

    private void createImageModels() {
        Map<String, Image> images = Optionals.of(this.gltf.getImages());
        for (Image image : images.values()) {
            DefaultImageModel imageModel = new DefaultImageModel();
            String uri = image.getUri();
            imageModel.setUri(uri);
            this.gltfModel.addImageModel(imageModel);
        }
    }

    private void createMaterialModels() {
        Map<String, Material> materials = Optionals.of(this.gltf.getMaterials());
        for (int i = 0; i < materials.size(); ++i) {
            this.gltfModel.addMaterialModel(new MaterialModelV1());
        }
    }

    private void createMeshModels() {
        Map<String, Mesh> meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            this.gltfModel.addMeshModel(new DefaultMeshModel());
        }
    }

    private void createNodeModels() {
        Map<String, Node> nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            this.gltfModel.addNodeModel(new DefaultNodeModel());
        }
    }

    private void createSceneModels() {
        Map<String, Scene> scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            this.gltfModel.addSceneModel(new DefaultSceneModel());
        }
    }

    private void createSkinModels() {
        Map<String, Skin> skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry<String, Skin> entry : skins.entrySet()) {
            Skin skin = entry.getValue();
            float[] bindShapeMatrix = skin.getBindShapeMatrix();
            DefaultSkinModel skinModel = new DefaultSkinModel();
            skinModel.setBindShapeMatrix(bindShapeMatrix);
            this.gltfModel.addSkinModel(skinModel);
        }
    }

    private void createTextureModels() {
        Map<String, Texture> textures = Optionals.of(this.gltf.getTextures());
        Map<String, Sampler> samplers = Optionals.of(this.gltf.getSamplers());
        for (Map.Entry<String, Texture> entry : textures.entrySet()) {
            Texture texture = entry.getValue();
            String samplerId = texture.getSampler();
            Sampler sampler = samplers.get(samplerId);
            int magFilter = Optionals.of(sampler.getMagFilter(), sampler.defaultMagFilter());
            int minFilter = Optionals.of(sampler.getMinFilter(), sampler.defaultMinFilter());
            int wrapS = Optionals.of(sampler.getWrapS(), sampler.defaultWrapS());
            int wrapT = Optionals.of(sampler.getWrapT(), sampler.defaultWrapT());
            DefaultTextureModel textureModel = new DefaultTextureModel();
            textureModel.setMagFilter(magFilter);
            textureModel.setMinFilter(minFilter);
            textureModel.setWrapS(wrapS);
            textureModel.setWrapT(wrapT);
            this.gltfModel.addTextureModel(textureModel);
        }
    }

    private void createShaderModels() {
        Map<String, Shader> shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry<String, Shader> entry : shaders.entrySet()) {
            Shader shader = entry.getValue();
            Integer type = shader.getType();
            ShaderModel.ShaderType shaderType = null;
            shaderType = type == 35633 ? ShaderModel.ShaderType.VERTEX_SHADER : ShaderModel.ShaderType.FRAGMENT_SHADER;
            DefaultShaderModel shaderModel = new DefaultShaderModel(shader.getUri(), shaderType);
            this.gltfModel.addShaderModel(shaderModel);
        }
    }

    private void createProgramModels() {
        Map<String, Program> programs = Optionals.of(this.gltf.getPrograms());
        for (int i = 0; i < programs.size(); ++i) {
            this.gltfModel.addProgramModel(new DefaultProgramModel());
        }
    }

    private void createTechniqueModels() {
        Map<String, Technique> techniques = Optionals.of(this.gltf.getTechniques());
        for (int i = 0; i < techniques.size(); ++i) {
            this.gltfModel.addTechniqueModel(new DefaultTechniqueModel());
        }
    }

    private void initAccessorModels() {
        Map<String, Accessor> accessors = Optionals.of(this.gltf.getAccessors());
        for (Map.Entry<String, Accessor> entry : accessors.entrySet()) {
            String accessorId = entry.getKey();
            Accessor accessor = entry.getValue();
            String bufferViewId = accessor.getBufferView();
            BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
            DefaultAccessorModel accessorModel = this.get("accessors", accessorId, this.gltfModel::getAccessorModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(accessor, accessorModel);
            accessorModel.setBufferViewModel(bufferViewModel);
            accessorModel.setAccessorData(AccessorDatas.create(accessorModel));
        }
    }

    private void initAnimationModels() {
        Map<String, Animation> animations = Optionals.of(this.gltf.getAnimations());
        for (Map.Entry<String, Animation> entry : animations.entrySet()) {
            String animationId = entry.getKey();
            Animation animation = entry.getValue();
            DefaultAnimationModel animationModel = this.get("animations", animationId, this.gltfModel::getAnimationModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(animation, animationModel);
            List<AnimationChannel> channels = Optionals.of(animation.getChannels());
            for (AnimationChannel animationChannel : channels) {
                AnimationModel.Channel channel = this.createChannel(animation, animationChannel);
                animationModel.addChannel(channel);
            }
        }
    }

    private void initImageModels() {
        Map<String, Image> images = Optionals.of(this.gltf.getImages());
        for (Map.Entry<String, Image> entry : images.entrySet()) {
            String mimeType;
            ByteBuffer imageData;
            String imageId = entry.getKey();
            Image image = entry.getValue();
            DefaultImageModel imageModel = this.get("images", imageId, this.gltfModel::getImageModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(image, imageModel);
            if (BinaryGltfV1.hasBinaryGltfExtension(image)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId(image);
                BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
                imageModel.setBufferViewModel(bufferViewModel);
            } else {
                String uri = image.getUri();
                if (IO.isDataUriString(uri)) {
                    byte[] data = IO.readDataUri(uri);
                    ByteBuffer imageData2 = Buffers.create(data);
                    imageModel.setImageData(imageData2);
                } else {
                    imageData = this.gltfAsset.getReferenceData(uri);
                    imageModel.setImageData(imageData);
                }
            }
            if ((mimeType = imageModel.getMimeType()) != null) continue;
            imageData = imageModel.getImageData();
            mimeType = MimeTypes.guessImageMimeTypeStringUnchecked(imageData);
            imageModel.setMimeType(mimeType);
        }
    }

    private AnimationModel.Channel createChannel(Animation animation, AnimationChannel animationChannel) {
        String samplerId;
        Map<String, AnimationSampler> samplers;
        AnimationSampler animationSampler;
        String inputParameterId;
        Map<String, String> parameters = Optionals.of(animation.getParameters());
        String inputAccessorId = parameters.get(inputParameterId = (animationSampler = (samplers = Optionals.of(animation.getSamplers())).get(samplerId = animationChannel.getSampler())).getInput());
        if (inputAccessorId == null) {
            logger.warning("Assuming " + inputParameterId + " to be an accessor ID");
            inputAccessorId = inputParameterId;
        }
        AccessorModel inputAccessorModel = this.get("accessors", inputAccessorId, this.gltfModel::getAccessorModel);
        String outputParameterId = animationSampler.getOutput();
        String outputAccessorId = parameters.get(outputParameterId);
        if (outputAccessorId == null) {
            logger.warning("Assuming " + outputParameterId + " to be an accessor ID");
            outputAccessorId = outputParameterId;
        }
        AccessorModel outputAccessorModel = this.get("accessors", outputAccessorId, this.gltfModel::getAccessorModel);
        String interpolationString = animationSampler.getInterpolation();
        AnimationModel.Interpolation interpolation = interpolationString == null ? AnimationModel.Interpolation.LINEAR : AnimationModel.Interpolation.valueOf(interpolationString);
        DefaultAnimationModel.DefaultSampler sampler = new DefaultAnimationModel.DefaultSampler(inputAccessorModel, interpolation, outputAccessorModel);
        AnimationChannelTarget animationChannelTarget = animationChannel.getTarget();
        String nodeId = animationChannelTarget.getId();
        String path = animationChannelTarget.getPath();
        NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
        DefaultAnimationModel.DefaultChannel channel = new DefaultAnimationModel.DefaultChannel(sampler, nodeModel, path);
        return channel;
    }

    private void initBufferModels() {
        ByteBuffer binaryData = null;
        ByteBuffer b = this.gltfAsset.getBinaryData();
        if (b != null && b.capacity() > 0) {
            binaryData = b;
        }
        Map<String, Buffer> buffers = Optionals.of(this.gltf.getBuffers());
        for (Map.Entry<String, Buffer> entry : buffers.entrySet()) {
            String bufferId = entry.getKey();
            Buffer buffer = entry.getValue();
            DefaultBufferModel bufferModel = this.get("buffers", bufferId, this.gltfModel::getBufferModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(buffer, bufferModel);
            if (BinaryGltfV1.isBinaryGltfBufferId(bufferId)) {
                if (binaryData == null) {
                    logger.severe("The glTF contains a buffer with the binary buffer ID, but no binary data has been given");
                    continue;
                }
                bufferModel.setBufferData(binaryData);
                continue;
            }
            String uri = buffer.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer bufferData = Buffers.create(data);
                bufferModel.setBufferData(bufferData);
                continue;
            }
            ByteBuffer bufferData = this.gltfAsset.getReferenceData(uri);
            bufferModel.setBufferData(bufferData);
        }
    }

    private void initBufferViewModels() {
        Map<String, BufferView> bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (Map.Entry<String, BufferView> entry : bufferViews.entrySet()) {
            String bufferViewId = entry.getKey();
            BufferView bufferView = entry.getValue();
            String bufferId = bufferView.getBuffer();
            BufferModel bufferModel = this.get("buffers", bufferId, this.gltfModel::getBufferModel);
            DefaultBufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(bufferView, bufferViewModel);
            bufferViewModel.setBufferModel(bufferModel);
        }
    }

    private List<DefaultAccessorModel> computeAccessorModelsOf(BufferViewModel bufferViewModel) {
        ArrayList<DefaultAccessorModel> result = new ArrayList<DefaultAccessorModel>();
        int n = this.gltfModel.getAccessorModels().size();
        for (int i = 0; i < n; ++i) {
            DefaultAccessorModel accessorModel = this.gltfModel.getAccessorModel(i);
            BufferViewModel b = accessorModel.getBufferViewModel();
            if (!bufferViewModel.equals(b)) continue;
            result.add(accessorModel);
        }
        return result;
    }

    private static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = -1;
        for (AccessorModel accessorModel : accessorModels) {
            int byteStride = accessorModel.getByteStride();
            if (commonByteStride == -1) {
                commonByteStride = byteStride;
                continue;
            }
            if (commonByteStride == byteStride) continue;
            logger.warning("The accessor models do not have the same byte stride: " + commonByteStride + " and " + byteStride);
        }
        return commonByteStride;
    }

    private void assignBufferViewByteStrides() {
        int n = this.gltfModel.getBufferModels().size();
        for (int i = 0; i < n; ++i) {
            DefaultBufferViewModel bufferViewModel = this.gltfModel.getBufferViewModel(i);
            List<DefaultAccessorModel> accessorModelsOfBufferView = this.computeAccessorModelsOf(bufferViewModel);
            if (accessorModelsOfBufferView.size() <= 1) continue;
            int byteStride = GltfModelCreatorV1.computeCommonByteStride(accessorModelsOfBufferView);
            bufferViewModel.setByteStride(byteStride);
        }
    }

    private void initMeshModels() {
        Map<String, Mesh> meshes = Optionals.of(this.gltf.getMeshes());
        for (Map.Entry<String, Mesh> entry : meshes.entrySet()) {
            String meshId = entry.getKey();
            Mesh mesh = entry.getValue();
            List<MeshPrimitive> primitives = Optionals.of(mesh.getPrimitives());
            DefaultMeshModel meshModel = this.get("meshes", meshId, this.gltfModel::getMeshModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(mesh, meshModel);
            for (MeshPrimitive meshPrimitive : primitives) {
                DefaultMeshPrimitiveModel meshPrimitiveModel = this.createMeshPrimitiveModel(meshPrimitive);
                meshModel.addMeshPrimitiveModel(meshPrimitiveModel);
            }
        }
    }

    private DefaultMeshPrimitiveModel createMeshPrimitiveModel(MeshPrimitive meshPrimitive) {
        Integer mode = Optionals.of(meshPrimitive.getMode(), meshPrimitive.defaultMode());
        DefaultMeshPrimitiveModel meshPrimitiveModel = new DefaultMeshPrimitiveModel(mode);
        GltfModelCreatorV1.transferGltfPropertyElements(meshPrimitive, meshPrimitiveModel);
        String indicesId = meshPrimitive.getIndices();
        if (indicesId != null) {
            AccessorModel indices = this.get("accessors", indicesId, this.gltfModel::getAccessorModel);
            meshPrimitiveModel.setIndices(indices);
        }
        Map<String, String> attributes = Optionals.of(meshPrimitive.getAttributes());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            String attributeId = entry.getValue();
            AccessorModel attribute = this.get("accessors", attributeId, this.gltfModel::getAccessorModel);
            meshPrimitiveModel.putAttribute(attributeName, attribute);
        }
        String materialId = meshPrimitive.getMaterial();
        if (materialId == null || GltfDefaults.isDefaultMaterialId(materialId)) {
            meshPrimitiveModel.setMaterialModel(DefaultModels.getDefaultMaterialModel());
        } else {
            MaterialModel materialModel = this.get("materials", materialId, this.gltfModel::getMaterialModel);
            meshPrimitiveModel.setMaterialModel(materialModel);
        }
        return meshPrimitiveModel;
    }

    private void initNodeModels() {
        Map<String, Node> nodes = Optionals.of(this.gltf.getNodes());
        for (Map.Entry<String, Node> entry : nodes.entrySet()) {
            String cameraId;
            String nodeId = entry.getKey();
            Node node = entry.getValue();
            DefaultNodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(node, nodeModel);
            List<String> childIds = Optionals.of(node.getChildren());
            for (String string : childIds) {
                DefaultNodeModel child = this.get("nodes", string, this.gltfModel::getNodeModel);
                nodeModel.addChild(child);
            }
            List<String> meshIds = Optionals.of(node.getMeshes());
            for (String meshId : meshIds) {
                MeshModel meshModel = this.get("meshes", meshId, this.gltfModel::getMeshModel);
                nodeModel.addMeshModel(meshModel);
            }
            String string = node.getSkin();
            if (string != null) {
                SkinModel skinModel = this.get("skins", string, this.gltfModel::getSkinModel);
                nodeModel.setSkinModel(skinModel);
            }
            if ((cameraId = node.getCamera()) != null) {
                CameraModel cameraModel = this.get("cameras", cameraId, this.gltfModel::getCameraModel);
                nodeModel.setCameraModel(cameraModel);
            }
            float[] matrix = node.getMatrix();
            float[] translation = node.getTranslation();
            float[] rotation = node.getRotation();
            float[] scale = node.getScale();
            nodeModel.setMatrix(Optionals.clone(matrix));
            nodeModel.setTranslation(Optionals.clone(translation));
            nodeModel.setRotation(Optionals.clone(rotation));
            nodeModel.setScale(Optionals.clone(scale));
        }
    }

    private void initSceneModels() {
        Map<String, Scene> scenes = Optionals.of(this.gltf.getScenes());
        for (Map.Entry<String, Scene> entry : scenes.entrySet()) {
            String sceneId = entry.getKey();
            Scene scene = entry.getValue();
            DefaultSceneModel sceneModel = this.get("scenes", sceneId, this.gltfModel::getSceneModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(scene, sceneModel);
            List<String> nodes = Optionals.of(scene.getNodes());
            for (String nodeId : nodes) {
                NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
                sceneModel.addNode(nodeModel);
            }
        }
    }

    private static Map<String, String> computeJointNameToNodeIdMap(GlTF gltf) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map<String, Node> nodes = Optionals.of(gltf.getNodes());
        for (Map.Entry<String, Node> entry : nodes.entrySet()) {
            String oldNodeId;
            String nodeId = entry.getKey();
            Node node = entry.getValue();
            if (node.getJointName() == null || (oldNodeId = map.put(node.getJointName(), nodeId)) == null) continue;
            logger.warning("Joint name " + node.getJointName() + " is mapped to nodes with IDs " + nodeId + " and " + oldNodeId);
        }
        return map;
    }

    private void initSkinModels() {
        Map<String, String> jointNameToNodeIdMap = GltfModelCreatorV1.computeJointNameToNodeIdMap(this.gltf);
        Map<String, Skin> skins = Optionals.of(this.gltf.getSkins());
        for (Map.Entry<String, Skin> entry : skins.entrySet()) {
            String skinId = entry.getKey();
            Skin skin = entry.getValue();
            DefaultSkinModel skinModel = this.get("skins", skinId, this.gltfModel::getSkinModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(skin, skinModel);
            List<String> jointNames = skin.getJointNames();
            for (String jointName : jointNames) {
                String nodeId = jointNameToNodeIdMap.get(jointName);
                NodeModel nodeModel = this.get("nodes", nodeId, this.gltfModel::getNodeModel);
                skinModel.addJoint(nodeModel);
            }
            String inverseBindMatricesId = skin.getInverseBindMatrices();
            AccessorModel inverseBindMatrices = this.get("accessors", inverseBindMatricesId, this.gltfModel::getAccessorModel);
            skinModel.setInverseBindMatrices(inverseBindMatrices);
        }
    }

    private void initTextureModels() {
        Map<String, Texture> textures = Optionals.of(this.gltf.getTextures());
        for (Map.Entry<String, Texture> entry : textures.entrySet()) {
            String textureId = entry.getKey();
            Texture texture = entry.getValue();
            DefaultTextureModel textureModel = this.get("textures", textureId, this.gltfModel::getTextureModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(texture, textureModel);
            String imageId = texture.getSource();
            DefaultImageModel imageModel = this.get("images", imageId, this.gltfModel::getImageModel);
            textureModel.setImageModel(imageModel);
        }
    }

    private void initShaderModels() {
        Map<String, Shader> shaders = Optionals.of(this.gltf.getShaders());
        for (Map.Entry<String, Shader> entry : shaders.entrySet()) {
            String shaderId = entry.getKey();
            Shader shader = entry.getValue();
            DefaultShaderModel shaderModel = this.get("shaders", shaderId, this.gltfModel::getShaderModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(shader, shaderModel);
            if (BinaryGltfV1.hasBinaryGltfExtension(shader)) {
                String bufferViewId = BinaryGltfV1.getBinaryGltfBufferViewId(shader);
                BufferViewModel bufferViewModel = this.get("bufferViews", bufferViewId, this.gltfModel::getBufferViewModel);
                shaderModel.setBufferViewModel(bufferViewModel);
                continue;
            }
            String uri = shader.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer shaderData = Buffers.create(data);
                shaderModel.setShaderData(shaderData);
                continue;
            }
            ByteBuffer shaderData = this.gltfAsset.getReferenceData(uri);
            shaderModel.setShaderData(shaderData);
        }
    }

    void initProgramModels() {
        Map<String, Program> programs = Optionals.of(this.gltf.getPrograms());
        for (Map.Entry<String, Program> entry : programs.entrySet()) {
            String programId = entry.getKey();
            Program program = entry.getValue();
            DefaultProgramModel programModel = this.get("programs", programId, this.gltfModel::getProgramModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(program, programModel);
            String vertexShaderId = program.getVertexShader();
            DefaultShaderModel vertexShaderModel = this.get("shaders", vertexShaderId, this.gltfModel::getShaderModel);
            programModel.setVertexShaderModel(vertexShaderModel);
            String fragmentShaderId = program.getFragmentShader();
            DefaultShaderModel fragmentShaderModel = this.get("shaders", fragmentShaderId, this.gltfModel::getShaderModel);
            programModel.setFragmentShaderModel(fragmentShaderModel);
            List<String> attributes = Optionals.of(program.getAttributes());
            for (String attribute : attributes) {
                programModel.addAttribute(attribute);
            }
        }
    }

    private static void addParameters(Technique technique, DefaultTechniqueModel techniqueModel, Function<? super String, ? extends NodeModel> nodeLookup) {
        Map<String, TechniqueParameters> parameters = Optionals.of(technique.getParameters());
        for (Map.Entry<String, TechniqueParameters> entry : parameters.entrySet()) {
            String parameterName = entry.getKey();
            TechniqueParameters parameter = entry.getValue();
            int type = parameter.getType();
            int count = Optionals.of(parameter.getCount(), 1);
            String semantic = parameter.getSemantic();
            Object value = parameter.getValue();
            String nodeId = parameter.getNode();
            NodeModel nodeModel = null;
            if (nodeId != null) {
                if (nodeLookup == null) {
                    logger.severe("No lookup function found for the nodes");
                } else {
                    nodeModel = nodeLookup.apply(nodeId);
                }
            }
            DefaultTechniqueParametersModel techniqueParametersModel = new DefaultTechniqueParametersModel(type, count, semantic, value, nodeModel);
            techniqueModel.addParameter(parameterName, techniqueParametersModel);
        }
    }

    private static void addAttributes(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map<String, String> attributes = Optionals.of(technique.getAttributes());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            String parameterName = entry.getValue();
            techniqueModel.addAttribute(attributeName, parameterName);
        }
    }

    private static void addUniforms(Technique technique, DefaultTechniqueModel techniqueModel) {
        Map<String, String> uniforms = Optionals.of(technique.getUniforms());
        for (Map.Entry<String, String> entry : uniforms.entrySet()) {
            String uniformName = entry.getKey();
            String parameterName = entry.getValue();
            techniqueModel.addUniform(uniformName, parameterName);
        }
    }

    private void initTechniqueModels() {
        Map<String, Technique> techniques = Optionals.of(this.gltf.getTechniques());
        for (Map.Entry<String, Technique> entry : techniques.entrySet()) {
            String techniqueId = entry.getKey();
            Technique technique = entry.getValue();
            DefaultTechniqueModel techniqueModel = this.get("techniques", techniqueId, this.gltfModel::getTechniqueModel);
            String programId = technique.getProgram();
            DefaultProgramModel programModel = this.get("programs", programId, this.gltfModel::getProgramModel);
            techniqueModel.setProgramModel(programModel);
            Function<String, NodeModel> nodeLookup = nodeId -> this.get("nodes", (String)nodeId, this.gltfModel::getNodeModel);
            GltfModelCreatorV1.initTechniqueModel(techniqueModel, technique, nodeLookup);
        }
    }

    public static void initTechniqueModel(DefaultTechniqueModel techniqueModel, Technique technique, Function<? super String, ? extends NodeModel> nodeLookup) {
        GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(technique, techniqueModel);
        GltfModelCreatorV1.addParameters(technique, techniqueModel, nodeLookup);
        GltfModelCreatorV1.addAttributes(technique, techniqueModel);
        GltfModelCreatorV1.addUniforms(technique, techniqueModel);
        ArrayList<Integer> enableModel = null;
        DefaultTechniqueStatesFunctionsModel techniqueStatesFunctionsModel = null;
        TechniqueStates states = technique.getStates();
        if (states != null) {
            TechniqueStatesFunctions functions;
            List<Integer> enable = states.getEnable();
            if (enable != null) {
                enableModel = new ArrayList<Integer>(enable);
            }
            if ((functions = states.getFunctions()) != null) {
                techniqueStatesFunctionsModel = TechniqueStatesFunctionsModels.create(functions);
            }
            DefaultTechniqueStatesModel techniqueStatesModel = new DefaultTechniqueStatesModel(enableModel, techniqueStatesFunctionsModel);
            techniqueModel.setTechniqueStatesModel(techniqueStatesModel);
        }
    }

    private void initMaterialModels() {
        Map<String, Material> materials = Optionals.of(this.gltf.getMaterials());
        for (Map.Entry<String, Material> entry : materials.entrySet()) {
            String materialId = entry.getKey();
            Material material = entry.getValue();
            MaterialModelV1 materialModel = (MaterialModelV1)this.get("materials", materialId, this.gltfModel::getMaterialModel);
            GltfModelCreatorV1.transferGltfChildOfRootPropertyElements(material, materialModel);
            String techniqueId = material.getTechnique();
            TechniqueModel techniqueModel = techniqueId == null || GltfDefaults.isDefaultTechniqueId(techniqueId) ? DefaultModels.getDefaultTechniqueModel() : (TechniqueModel)this.get("techniques", techniqueId, this.gltfModel::getTechniqueModel);
            materialModel.setTechniqueModel(techniqueModel);
            LinkedHashMap<String, Object> modelValues = new LinkedHashMap<String, Object>();
            Map<String, Object> values = Optionals.of(material.getValues());
            for (Map.Entry<String, Object> valueEntry : values.entrySet()) {
                String parameterName = valueEntry.getKey();
                TechniqueParametersModel techniqueParametersModel = techniqueModel.getParameters().get(parameterName);
                if (techniqueParametersModel != null && techniqueParametersModel.getType() == 35678) {
                    TextureModel textureModel = null;
                    Object value = valueEntry.getValue();
                    if (value != null) {
                        String textureId = String.valueOf(value);
                        textureModel = this.get("textures", textureId, this.gltfModel::getTextureModel);
                    }
                    modelValues.put(parameterName, textureModel);
                    continue;
                }
                modelValues.put(parameterName, valueEntry.getValue());
            }
            materialModel.setValues(modelValues);
        }
    }

    private void initExtensionsModel() {
        List<String> extensionsUsed = this.gltf.getExtensionsUsed();
        DefaultExtensionsModel extensionsModel = this.gltfModel.getExtensionsModel();
        extensionsModel.addExtensionsUsed(extensionsUsed);
    }

    private void initAssetModel() {
        Asset asset = this.gltf.getAsset();
        if (asset != null) {
            DefaultAssetModel assetModel = this.gltfModel.getAssetModel();
            GltfModelCreatorV1.transferGltfPropertyElements(asset, assetModel);
            assetModel.setCopyright(asset.getCopyright());
            assetModel.setGenerator(asset.getGenerator());
        }
    }

    private static void transferGltfPropertyElements(GlTFProperty property, AbstractModelElement modelElement) {
        modelElement.setExtensions(property.getExtensions());
        modelElement.setExtras(property.getExtras());
    }

    private static void transferGltfChildOfRootPropertyElements(GlTFChildOfRootProperty property, AbstractNamedModelElement modelElement) {
        modelElement.setName(property.getName());
        GltfModelCreatorV1.transferGltfPropertyElements(property, modelElement);
    }

    private <T> T get(String name, String id, IntFunction<? extends T> getter) {
        Integer index = this.indexMappingSet.getIndex(name, id);
        if (index == null) {
            logger.severe("No index found for " + name + " ID " + id);
            return null;
        }
        T element = getter.apply(index);
        return element;
    }
}

