/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.v1;

import com.voxelbridge.shadow.jgltf.model.GltfModel;
import com.voxelbridge.shadow.jgltf.model.gl.ProgramModel;
import com.voxelbridge.shadow.jgltf.model.gl.ShaderModel;
import com.voxelbridge.shadow.jgltf.model.gl.TechniqueModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultProgramModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultShaderModel;
import com.voxelbridge.shadow.jgltf.model.gl.impl.DefaultTechniqueModel;
import com.voxelbridge.shadow.jgltf.model.impl.DefaultGltfModel;
import com.voxelbridge.shadow.jgltf.model.io.v1.GltfAssetV1;
import com.voxelbridge.shadow.jgltf.model.v1.GltfModelCreatorV1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class GltfModelV1
extends DefaultGltfModel
implements GltfModel {
    private final List<DefaultShaderModel> shaderModels;
    private final List<DefaultProgramModel> programModels;
    private final List<DefaultTechniqueModel> techniqueModels;

    public GltfModelV1(GltfAssetV1 gltfAsset) {
        Objects.requireNonNull(gltfAsset, "The gltfAsset may not be null");
        this.shaderModels = new ArrayList<DefaultShaderModel>();
        this.programModels = new ArrayList<DefaultProgramModel>();
        this.techniqueModels = new ArrayList<DefaultTechniqueModel>();
        GltfModelCreatorV1 gltfModelCreatorV1 = new GltfModelCreatorV1(gltfAsset, this);
        gltfModelCreatorV1.create();
    }

    public GltfModelV1() {
        this.shaderModels = new ArrayList<DefaultShaderModel>();
        this.programModels = new ArrayList<DefaultProgramModel>();
        this.techniqueModels = new ArrayList<DefaultTechniqueModel>();
    }

    public void addShaderModel(DefaultShaderModel shaderModel) {
        this.shaderModels.add(shaderModel);
    }

    public void removeShaderModel(DefaultShaderModel shaderModel) {
        this.shaderModels.remove(shaderModel);
    }

    public void addShaderModels(Collection<? extends DefaultShaderModel> shaderModels) {
        for (DefaultShaderModel defaultShaderModel : shaderModels) {
            this.addShaderModel(defaultShaderModel);
        }
    }

    public DefaultShaderModel getShaderModel(int index) {
        return this.shaderModels.get(index);
    }

    public void clearShaderModels() {
        this.shaderModels.clear();
    }

    public List<ShaderModel> getShaderModels() {
        return Collections.unmodifiableList(this.shaderModels);
    }

    public void addProgramModel(DefaultProgramModel programModel) {
        this.programModels.add(programModel);
    }

    public void removeProgramModel(DefaultProgramModel programModel) {
        this.programModels.remove(programModel);
    }

    public void addProgramModels(Collection<? extends DefaultProgramModel> programModels) {
        for (DefaultProgramModel defaultProgramModel : programModels) {
            this.addProgramModel(defaultProgramModel);
        }
    }

    public DefaultProgramModel getProgramModel(int index) {
        return this.programModels.get(index);
    }

    public void clearProgramModels() {
        this.programModels.clear();
    }

    public List<ProgramModel> getProgramModels() {
        return Collections.unmodifiableList(this.programModels);
    }

    public void addTechniqueModel(DefaultTechniqueModel techniqueModel) {
        this.techniqueModels.add(techniqueModel);
    }

    public void removeTechniqueModel(DefaultTechniqueModel techniqueModel) {
        this.techniqueModels.remove(techniqueModel);
    }

    public void addTechniqueModels(Collection<? extends DefaultTechniqueModel> techniqueModels) {
        for (DefaultTechniqueModel defaultTechniqueModel : techniqueModels) {
            this.addTechniqueModel(defaultTechniqueModel);
        }
    }

    public DefaultTechniqueModel getTechniqueModel(int index) {
        return this.techniqueModels.get(index);
    }

    public void clearTechniqueModels() {
        this.techniqueModels.clear();
    }

    public List<TechniqueModel> getTechniqueModels() {
        return Collections.unmodifiableList(this.techniqueModels);
    }
}

