/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.v1.gl;

import com.voxelbridge.shadow.jgltf.impl.v1.Technique;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueParameters;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStates;
import com.voxelbridge.shadow.jgltf.impl.v1.TechniqueStatesFunctions;
import com.voxelbridge.shadow.jgltf.model.v1.gl.GltfDefaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Techniques {
    static Technique createDefaultTechnique(String programId) {
        Technique technique = new Technique();
        technique.addAttributes("a_position", "position");
        technique.addParameters("modelViewMatrix", Techniques.createDefaultTechniqueParameters("MODELVIEW", 35676, null));
        technique.addParameters("projectionMatrix", Techniques.createDefaultTechniqueParameters("PROJECTION", 35676, null));
        technique.addParameters("emission", Techniques.createDefaultTechniqueParameters(null, 35666, Arrays.asList(Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(1.0f))));
        technique.addParameters("position", Techniques.createDefaultTechniqueParameters("POSITION", 35665, null));
        technique.setStates(Techniques.createDefaultTechniqueStates());
        technique.setProgram(programId);
        technique.addUniforms("u_modelViewMatrix", "modelViewMatrix");
        technique.addUniforms("u_projectionMatrix", "projectionMatrix");
        technique.addUniforms("u_emission", "emission");
        return technique;
    }

    private static TechniqueStates createDefaultTechniqueStates() {
        TechniqueStates techniqueStates = new TechniqueStates();
        techniqueStates.setEnable(new ArrayList<Integer>(techniqueStates.defaultEnable()));
        techniqueStates.setFunctions(Techniques.createDefaultTechniqueStatesFunctions());
        return techniqueStates;
    }

    public static TechniqueStatesFunctions createDefaultTechniqueStatesFunctions() {
        TechniqueStatesFunctions techniqueStatesFunctions = new TechniqueStatesFunctions();
        techniqueStatesFunctions.setBlendColor(techniqueStatesFunctions.defaultBlendColor());
        techniqueStatesFunctions.setBlendEquationSeparate(techniqueStatesFunctions.defaultBlendEquationSeparate());
        techniqueStatesFunctions.setBlendFuncSeparate(techniqueStatesFunctions.defaultBlendFuncSeparate());
        techniqueStatesFunctions.setColorMask(techniqueStatesFunctions.defaultColorMask());
        techniqueStatesFunctions.setCullFace(techniqueStatesFunctions.defaultCullFace());
        techniqueStatesFunctions.setDepthFunc(techniqueStatesFunctions.defaultDepthFunc());
        techniqueStatesFunctions.setDepthMask(techniqueStatesFunctions.defaultDepthMask());
        techniqueStatesFunctions.setDepthRange(techniqueStatesFunctions.defaultDepthRange());
        techniqueStatesFunctions.setFrontFace(techniqueStatesFunctions.defaultFrontFace());
        techniqueStatesFunctions.setLineWidth(techniqueStatesFunctions.defaultLineWidth());
        techniqueStatesFunctions.setPolygonOffset(techniqueStatesFunctions.defaultPolygonOffset());
        techniqueStatesFunctions.setScissor(techniqueStatesFunctions.defaultScissor());
        return techniqueStatesFunctions;
    }

    private static TechniqueParameters createDefaultTechniqueParameters(String semantic, Integer type, Object value) {
        TechniqueParameters techniqueParameters = new TechniqueParameters();
        techniqueParameters.setSemantic(semantic);
        techniqueParameters.setType(type);
        techniqueParameters.setValue(value);
        return techniqueParameters;
    }

    public static List<Integer> obtainEnabledStates(Technique technique) {
        TechniqueStates states = Techniques.obtainTechniqueStates(technique);
        List<Integer> enable = states.getEnable();
        if (enable == null) {
            return states.defaultEnable();
        }
        return enable;
    }

    private static TechniqueStates obtainTechniqueStates(Technique technique) {
        TechniqueStates states = technique.getStates();
        if (states == null) {
            return GltfDefaults.getDefaultTechnique().getStates();
        }
        return states;
    }

    public static TechniqueStatesFunctions obtainTechniqueStatesFunctions(Technique technique) {
        TechniqueStates states = Techniques.obtainTechniqueStates(technique);
        TechniqueStatesFunctions functions = states.getFunctions();
        if (functions == null) {
            TechniqueStates defaultStates = GltfDefaults.getDefaultTechnique().getStates();
            return defaultStates.getFunctions();
        }
        return functions;
    }

    private Techniques() {
    }
}

