/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.thread;

import com.voxelbridge.export.scene.gltf.GltfExportService;
import com.voxelbridge.util.ExportLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExportThread
extends Thread {
    private final Level level;
    private final BlockPos pos1;
    private final BlockPos pos2;
    private final Path outDir;

    public ExportThread(Level level, BlockPos pos1, BlockPos pos2, Path outDir) {
        this.level = level;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.outDir = outDir;
        this.setName("MineExporter-glTF");
    }

    @Override
    public void run() {
        Minecraft mc = Minecraft.getInstance();
        try {
            long start = System.currentTimeMillis();
            Path file = GltfExportService.exportRegion(this.level, this.pos1, this.pos2, this.outDir);
            long time = System.currentTimeMillis() - start;
            String msg = String.format("[VoxelBridge] Export completed! File: %s (%.2fs)", file.getFileName(), (double)time / 1000.0);
            mc.execute(() -> {
                if (mc.player != null) {
                    mc.player.displayClientMessage((Component)Component.literal((String)msg), false);
                }
            });
            System.out.println(msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ExportLogger.log("[GLTF][ERROR] Export failed: " + e.getMessage());
            ExportLogger.log(sw.toString());
            mc.execute(() -> {
                if (mc.player != null) {
                    mc.player.displayClientMessage((Component)Component.literal((String)("[VoxelBridge] Export failed: " + e.getMessage())), false);
                }
            });
        }
    }
}

