/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class ExportLogger {
    private static final boolean ENABLED = true;
    private static final DateTimeFormatter TIMESTAMP = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS");
    private static BufferedWriter writer;

    private ExportLogger() {
    }

    public static synchronized void initialize(Path outDir) throws IOException {
        writer = null;
        ExportLogger.close();
        Path logPath = outDir.resolve("voxelbridge-debug.log");
        writer = Files.newBufferedWriter(logPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        ExportLogger.log("Export log initialized");
    }

    public static synchronized void log(String message) {
        if (writer != null) {
            try {
                writer.write(String.format("[%s] %s%n", TIMESTAMP.format(LocalDateTime.now()), message));
                writer.flush();
            }
            catch (IOException e) {
                System.err.printf("[ExportLogger] Failed to write log: %s%n", e.getMessage());
            }
        }
    }

    public static synchronized void close() {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
            }
            finally {
                writer = null;
            }
        }
    }
}

