/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class IOUtil {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");

    private IOUtil() {
    }

    public static Path ensureExportDir() throws IOException {
        String timestamp;
        Path timestampDir;
        Path exportRoot = Path.of("export", new String[0]);
        if (!Files.exists(exportRoot, new LinkOption[0])) {
            Files.createDirectories(exportRoot, new FileAttribute[0]);
        }
        if (!Files.exists(timestampDir = exportRoot.resolve(timestamp = LocalDateTime.now().format(TIMESTAMP_FORMAT)), new LinkOption[0])) {
            Files.createDirectories(timestampDir, new FileAttribute[0]);
        }
        return timestampDir;
    }
}

