/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.BooleanValue EnableCactusMixin;
    public static final ForgeConfigSpec.BooleanValue EnableSplashPotionMixin;
    public static final ForgeConfigSpec.BooleanValue EnableItemNostackMixin;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        Stream<String> categories = VTweaks.getInstance().TweakRegistry.getAllTweaks().stream().map(tweak -> tweak.getClass().getAnnotation(Tweak.class).category()).sorted();
        categories.forEach(catNm -> {
            COMMON_BUILDER.push(catNm);
            VTweaks.getInstance().TweakRegistry.getAllTweaks().stream().filter(tweak -> tweak.getClass().getAnnotation(Tweak.class).category().equals(catNm)).forEach(tweak -> tweak.registerConfigs(COMMON_BUILDER));
            COMMON_BUILDER.pop();
        });
        COMMON_BUILDER.comment("All changes made here require a game restart.").push("mixins");
        EnableCactusMixin = COMMON_BUILDER.comment("If enabled, this tweak prevents cactus from destroying items that run into it").define("enableCactusItemProtection", true);
        EnableSplashPotionMixin = COMMON_BUILDER.comment("If enabled, allows splash potions of water to behave the same as throwing an item in water via V-Tweaks' Fluid Conversion Recipes").define("enableSplashPotionTweak", true);
        EnableItemNostackMixin = COMMON_BUILDER.comment("If enabled, items entities will no longer stack together like Minecraft Beta").define("enableNonStackingItemTweak", false);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

