/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.anvil;

import com.oitsjustjose.vtweaks.VTweaks;
import java.util.Arrays;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements Recipe<RecipeWrapper> {
    public final ResourceLocation id;
    private final Ingredient left;
    private final Ingredient right;
    private final ItemStack result;
    private final int cost;
    private final boolean copyNbtFromLeft;
    private final boolean copyNbtFromRight;
    private final boolean strictMatch;

    public AnvilRecipe(ResourceLocation id, Ingredient l, Ingredient r, ItemStack e, int c, boolean cpl, boolean cpr, boolean strict) {
        this.id = id;
        this.left = l;
        this.right = r;
        this.result = e;
        this.cost = c;
        this.copyNbtFromLeft = cpl;
        this.copyNbtFromRight = cpr;
        this.strictMatch = strict;
        VTweaks.getInstance().addAnvilRecipe(id, this);
    }

    public Ingredient getLeft() {
        return this.left;
    }

    public Ingredient getRight() {
        return this.right;
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public int getCost() {
        return this.cost;
    }

    public boolean shouldResultCopyNbtFromLeft() {
        return this.copyNbtFromLeft;
    }

    public boolean shouldResultCopyNbtFromRight() {
        return this.copyNbtFromRight;
    }

    public boolean isStrictMatch() {
        return this.strictMatch;
    }

    public boolean matches(@NotNull RecipeWrapper wrapper, @NotNull Level level) {
        boolean rightTagVerified;
        boolean leftTagVerified;
        ItemStack l = wrapper.m_8020_(0);
        ItemStack r = wrapper.m_8020_(1);
        if (l == null || r == null) {
            return false;
        }
        if (!this.left.test(l) || !this.right.test(r)) {
            return false;
        }
        if (!this.isStrictMatch()) {
            return true;
        }
        ItemStack leftIngredientMatch = Arrays.stream(this.left.m_43908_()).filter(x -> x.m_41720_() == l.m_41720_()).findFirst().orElse(ItemStack.f_41583_);
        ItemStack rightIngredientMatch = Arrays.stream(this.right.m_43908_()).filter(x -> x.m_41720_() == r.m_41720_()).findFirst().orElse(ItemStack.f_41583_);
        if (rightIngredientMatch.m_41619_() || leftIngredientMatch.m_41619_()) {
            VTweaks.getInstance().LOGGER.error("Anvil recipe [{} + {}] met an invalid state in AnvilRecipes#matches", (Object)l.toString(), (Object)r.toString());
            return false;
        }
        boolean bl = leftTagVerified = !leftIngredientMatch.m_41782_() && !l.m_41782_();
        if (leftIngredientMatch.m_41782_() && leftIngredientMatch.m_41783_() != null) {
            leftTagVerified = l.m_41782_() && this.bareMinimumCompare(leftIngredientMatch.m_41783_(), l.m_41783_());
        }
        boolean bl2 = rightTagVerified = !rightIngredientMatch.m_41782_() && !r.m_41782_();
        if (rightIngredientMatch.m_41782_() && rightIngredientMatch.m_41783_() != null) {
            rightTagVerified = r.m_41782_() && this.bareMinimumCompare(rightIngredientMatch.m_41783_(), r.m_41783_());
        }
        return leftTagVerified && rightTagVerified;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper unused, @NotNull RegistryAccess unused2) {
        return this.result;
    }

    private boolean bareMinimumCompare(CompoundTag orig, CompoundTag comp) {
        return orig.m_128431_().stream().allMatch(key -> this.compareTags(orig, comp, (String)key));
    }

    private boolean compareTags(CompoundTag orig, CompoundTag comp, String key) {
        if (!comp.m_128441_(key)) {
            return false;
        }
        switch (orig.m_128435_(key)) {
            case 1: {
                return orig.m_128445_(key) == comp.m_128445_(key);
            }
            case 2: {
                return orig.m_128448_(key) == comp.m_128448_(key);
            }
            case 3: {
                return orig.m_128451_(key) == comp.m_128451_(key);
            }
            case 4: {
                return orig.m_128454_(key) == comp.m_128454_(key);
            }
            case 5: {
                return orig.m_128457_(key) == comp.m_128457_(key);
            }
            case 6: {
                return orig.m_128459_(key) == comp.m_128459_(key);
            }
            case 7: {
                return Arrays.equals(orig.m_128463_(key), comp.m_128463_(key));
            }
            case 8: {
                return orig.m_128461_(key).equals(comp.m_128461_(key));
            }
            case 9: {
                ListTag origList = (ListTag)orig.m_128423_(key);
                ListTag compList = (ListTag)comp.m_128423_(key);
                if (origList == null || compList == null) {
                    return false;
                }
                if (origList.m_7264_() != 10) {
                    VTweaks.getInstance().LOGGER.info("List tag of type {} is not supported", (Object)origList.m_7264_());
                    return false;
                }
                for (int i = 0; i < origList.size(); ++i) {
                    boolean anyMatchedForThisEntry = false;
                    CompoundTag t1 = origList.m_128728_(i);
                    for (int j = 0; j < compList.size(); ++j) {
                        CompoundTag t2 = compList.m_128728_(j);
                        anyMatchedForThisEntry = this.bareMinimumCompare(t1, t2);
                    }
                    if (anyMatchedForThisEntry) continue;
                    return false;
                }
                return true;
            }
            case 10: {
                return this.bareMinimumCompare(orig.m_128469_(key), comp.m_128469_(key));
            }
            case 11: {
                return Arrays.equals(orig.m_128465_(key), comp.m_128465_(key));
            }
            case 12: {
                return Arrays.equals(orig.m_128467_(key), comp.m_128467_(key));
            }
        }
        VTweaks.getInstance().LOGGER.info("Received tag ID of {} which is not recognized", (Object)orig.m_7060_());
        return false;
    }

    public boolean m_8004_(int _a, int _b) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess unused) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return VTweaks.getInstance().CustomRecipeRegistry.ANVIL;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return VTweaks.getInstance().CustomRecipeRegistry.ANVIL_RECIPE_TYPE;
    }
}

