/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.anvil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.common.data.anvil.AnvilRecipe;
import com.oitsjustjose.vtweaks.common.data.helpers.VTJsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeSerializer
implements RecipeSerializer<AnvilRecipe> {
    @NotNull
    public AnvilRecipe fromJson(@NotNull ResourceLocation rl, @NotNull JsonObject obj) {
        Ingredient left = Ingredient.m_288218_((JsonElement)obj.get("left"), (boolean)false);
        Ingredient right = Ingredient.m_288218_((JsonElement)obj.get("right"), (boolean)false);
        ItemStack result = VTJsonHelpers.deserializeItemStack(obj, "result");
        int cost = obj.get("cost").getAsInt();
        boolean cpl = obj.has("copyTagsFromLeft") && obj.get("copyTagsFromLeft").getAsBoolean();
        boolean cpr = obj.has("copyTagsFromRight") && obj.get("copyTagsFromRight").getAsBoolean();
        boolean strict = obj.has("strict") && obj.get("strict").getAsBoolean();
        return new AnvilRecipe(rl, left, right, result, cost, cpl, cpr, strict);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull AnvilRecipe recipe) {
        CraftingHelper.write((FriendlyByteBuf)buf, (Ingredient)recipe.getLeft());
        CraftingHelper.write((FriendlyByteBuf)buf, (Ingredient)recipe.getRight());
        buf.writeItemStack(recipe.getResult(), false);
        buf.writeInt(recipe.getCost());
        buf.writeBoolean(recipe.shouldResultCopyNbtFromLeft());
        buf.writeBoolean(recipe.shouldResultCopyNbtFromRight());
        buf.writeBoolean(recipe.isStrictMatch());
    }

    @Nullable
    public AnvilRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        Ingredient left = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient right = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack result = buf.m_130267_();
        int cost = buf.readInt();
        boolean cpl = buf.readBoolean();
        boolean cpr = buf.readBoolean();
        boolean strict = buf.readBoolean();
        return new AnvilRecipe(id, left, right, result, cost, cpl, cpr, strict);
    }
}

