/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.BetterFallingBlock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="block.chopdown")
public class ChopDownTweak
extends VTweak {
    public ForgeConfigSpec.BooleanValue enabled;
    public ForgeConfigSpec.IntValue logCount;
    public ForgeConfigSpec.IntValue leafSearchRad;
    public ForgeConfigSpec.BooleanValue requireTool;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Trees fall down (like, actually not just like lumbering). Credit to Ternsip's impl (https://www.curseforge.com/minecraft/mc-mods/chopdown)").define("enableTreeChopDown", true);
        this.logCount = builder.comment("The number of logs above the one broken to trigger the chopdown effect").defineInRange("chopDownLogRequirement", 3, 1, Integer.MAX_VALUE);
        this.leafSearchRad = builder.comment("The radius that this tweak will use to attempt to find leaves. Set this to a large number to detect larger trees (may cause lag)").defineInRange("chopdownSearchRadius", 64, 1, Integer.MAX_VALUE);
        this.requireTool = builder.comment("If set to true, ChopDown will only work when the player is using the right tool for the log").define("requiresRightTool", false);
        builder.pop();
    }

    @SubscribeEvent
    public void process(BlockEvent.BreakEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = evt.getLevel();
        BlockPos initPos = evt.getPos();
        Player player = evt.getPlayer();
        if (((Boolean)this.requireTool.get()).booleanValue() && !ChopDownTweak.isBestTool(evt.getState(), player.m_21205_())) {
            return;
        }
        for (int dy = 0; dy < (Integer)this.logCount.get(); ++dy) {
            if (level.m_8055_(initPos.m_7918_(0, dy, 0)).m_204336_(BlockTags.f_13106_)) continue;
            return;
        }
        int leaves = 5;
        Integer rad = (Integer)this.leafSearchRad.get();
        boolean foundLeaves = false;
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashMap<BlockPos, Integer> used = new HashMap<BlockPos, Integer>();
        queue.add(initPos);
        used.put(initPos, leaves);
        while (!queue.isEmpty()) {
            BlockPos top = (BlockPos)queue.pollFirst();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        boolean isLeaf;
                        BlockPos tmp = top.m_7918_(dx, dy, dz);
                        Integer step = (Integer)used.get(top);
                        if (step <= 0 || tmp.m_123331_((Vec3i)initPos) > (double)(rad * rad)) continue;
                        BlockState state = level.m_8055_(tmp);
                        boolean isLog = state.m_204336_(BlockTags.f_13106_);
                        boolean bl = isLeaf = state.m_204336_(BlockTags.f_13035_) && (!state.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)state.m_61143_((Property)LeavesBlock.f_54419_) == false);
                        if (isLeaf && !foundLeaves) {
                            foundLeaves = true;
                        }
                        if ((dy < 0 || step != leaves || !isLog) && !isLeaf) continue;
                        step = step - (isLeaf ? 1 : 0);
                        if (used.containsKey(tmp) && (Integer)used.get(tmp) >= step) continue;
                        used.put(tmp, step);
                        queue.push(tmp);
                    }
                }
            }
        }
        if (!foundLeaves) {
            return;
        }
        Direction dir = this.directionFromPosDiff(player.m_20183_(), initPos);
        used.forEach((pos, cnt) -> {
            if (!initPos.equals(pos) && this.canBeMoved(level, pos.m_7918_(0, -1, 0))) {
                BlockPos transformed = this.getTransform(initPos, (BlockPos)pos, dir);
                this.moveAsBlockEntity(level, (BlockPos)pos, transformed, dir);
            }
        });
    }

    private void moveAsBlockEntity(LevelAccessor level, BlockPos pos, BlockPos newPos, Direction direction) {
        BlockState bs = this.rotate(level, pos, level.m_8055_(pos), direction);
        if (bs.m_204336_(BlockTags.f_13035_) && level.m_213780_().m_188499_()) {
            Block.m_49892_((BlockState)bs, (LevelAccessor)level, (BlockPos)newPos, null);
        } else {
            BetterFallingBlock falling = BetterFallingBlock.fall((Level)level, newPos, bs);
            level.m_7967_((Entity)falling);
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    private BlockPos getTransform(BlockPos initialBreakPos, BlockPos pos, Direction direction) {
        int transformedY = pos.m_123342_() - initialBreakPos.m_123342_();
        return switch (direction) {
            case Direction.SOUTH -> pos.m_7918_(0, 0, 1 + transformedY);
            case Direction.NORTH -> pos.m_7918_(0, 0, -transformedY - 1);
            case Direction.EAST -> pos.m_7918_(1 + transformedY, 0, 0);
            case Direction.WEST -> pos.m_7918_(-transformedY - 1, 0, 0);
            default -> pos;
        };
    }

    private boolean canBeMoved(LevelAccessor level, BlockPos pos) {
        BlockState bs = level.m_8055_(pos);
        return !bs.m_155947_() && (bs.m_204336_(BlockTags.f_13106_) || bs.m_204336_(BlockTags.f_13035_) && bs.m_61138_((Property)LeavesBlock.f_54419_) && (Boolean)bs.m_61143_((Property)LeavesBlock.f_54419_) == false || bs.m_204336_(BlockTags.f_13072_) || bs.m_60795_());
    }

    private BlockState rotate(LevelAccessor level, BlockPos pos, BlockState state, Direction direction) {
        if (state.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            BlockState ret = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X));
            return switch (direction) {
                case Direction.SOUTH, Direction.NORTH -> ret.rotate(level, pos, Rotation.CLOCKWISE_90);
                case Direction.EAST, Direction.WEST -> ret;
                default -> state;
            };
        }
        return state;
    }

    private Direction directionFromPosDiff(BlockPos playerPos, BlockPos brokenPos) {
        int dirZ;
        double abZ;
        double x = (double)brokenPos.m_123341_() + 0.5 - (double)playerPos.m_123341_();
        double z = (double)brokenPos.m_123343_() + 0.5 - (double)playerPos.m_123343_();
        double abX = Math.abs(x);
        int dirX = abX > (abZ = Math.abs(z)) ? (int)Math.floor(abX / x) : 0;
        int n = dirZ = abX > abZ ? 0 : (int)Math.floor(abZ / z);
        if (dirX != 0) {
            return dirX == 1 ? Direction.EAST : Direction.WEST;
        }
        return dirZ == 1 ? Direction.SOUTH : Direction.NORTH;
    }

    private static boolean isBestTool(BlockState stateIn, ItemStack toolIn) {
        if (toolIn.m_41619_()) {
            return false;
        }
        String searchKey = ":mineable/";
        Optional<TagKey> mineableKey = stateIn.m_204343_().filter(x -> x.f_203868_().toString().contains(searchKey)).findFirst();
        if (mineableKey.isEmpty()) {
            VTweaks.getInstance().LOGGER.warn("Failed to find mineable tag on block {} with tags {}", (Object)stateIn.m_60734_().m_7705_(), (Object)stateIn.m_204343_().map(x -> x.f_203868_().toString()).collect(Collectors.joining(", ")));
            return false;
        }
        String toolType = mineableKey.get().f_203868_().toString();
        toolType = toolType.substring(toolType.indexOf(searchKey) + searchKey.length());
        List<TagKey> variants = Arrays.asList(ItemTags.create((ResourceLocation)new ResourceLocation("minecraft", toolType + "s")), ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/" + toolType + "s")));
        for (TagKey variant : variants) {
            if (!toolIn.m_204117_(variant)) continue;
            return true;
        }
        return false;
    }
}

