/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.culling;

import com.mojang.datafixers.util.Either;
import com.oitsjustjose.vtweaks.VTweaks;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityCullingRule {
    private final List<Biome> biomes = new ArrayList<Biome>();
    private final List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
    private final List<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
    private final List<TagKey<EntityType<?>>> entityTypeTags = new ArrayList();
    private final List<ResourceLocation> entityTypes = new ArrayList<ResourceLocation>();

    public EntityCullingRule(List<String> biomeFilterRaw, List<String> dimFilterRaw, List<String> entityFilterRaw) {
        biomeFilterRaw.forEach(x -> {
            try {
                if (x.startsWith("#")) {
                    ResourceLocation location = new ResourceLocation(x.substring(1));
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)location);
                    this.biomeTags.add((TagKey<Biome>)tagKey);
                } else {
                    ResourceLocation location = new ResourceLocation(x);
                    Biome b = (Biome)ForgeRegistries.BIOMES.getValue(location);
                    if (b != null) {
                        this.biomes.add(b);
                    }
                }
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in biomes object {}: {}", x, (Object)e);
            }
        });
        dimFilterRaw.forEach(x -> {
            try {
                ResourceLocation location = new ResourceLocation(x);
                this.dimensions.add(location);
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in dimensions object {}: {}", x, (Object)e);
            }
        });
        entityFilterRaw.forEach(x -> {
            try {
                if (x.startsWith("#")) {
                    ResourceLocation location = new ResourceLocation(x.substring(1));
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)location);
                    this.entityTypeTags.add(tagKey);
                } else {
                    ResourceLocation location = new ResourceLocation(x);
                    EntityType ent = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
                    if (ent != null) {
                        this.entityTypes.add(location);
                    }
                }
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in entities object {}: {}", x, (Object)e);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public boolean apply(MobSpawnEvent.FinalizeSpawn evt) {
        hasMatchedOnEntity = this.entityTypes.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)evt.getEntity().m_6095_()));
        hasMatchedOnEntityType = this.entityTypeTags.stream().anyMatch((Predicate<TagKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$apply$3(net.minecraftforge.event.entity.living.MobSpawnEvent$FinalizeSpawn net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Z)((MobSpawnEvent.FinalizeSpawn)evt));
        if (!hasMatchedOnEntity && !hasMatchedOnEntityType) {
            return false;
        }
        lvl = (ServerLevel)evt.getLevel();
        dimName = lvl.m_46472_().m_135782_();
        biomeHolder = lvl.m_204166_(evt.getEntity().m_20183_());
        unwrappedBiome = biomeHolder.m_203439_();
        v0 = hasMatchedOnDim = this.dimensions.isEmpty() != false || this.dimensions.contains(dimName) != false;
        if (this.biomeTags.isEmpty()) ** GOTO lbl-1000
        if (this.biomeTags.stream().anyMatch((Predicate<TagKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, m_203656_(net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Z)((Holder)biomeHolder))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        hasMatchedOnBiomeTag = v1;
        hasMatchedOnBiome = this.biomes.isEmpty() != false || this.biomes.stream().anyMatch((Predicate<Biome>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$apply$4(com.mojang.datafixers.util.Either net.minecraft.world.level.biome.Biome ), (Lnet/minecraft/world/level/biome/Biome;)Z)((EntityCullingRule)this, (Either)unwrappedBiome)) != false;
        return hasMatchedOnDim != false && (hasMatchedOnBiome != false || hasMatchedOnBiomeTag != false);
    }

    public String toString() {
        return "EntityCullingRule for Entities" + this.entityTypes.toString() + " + " + this.entityTypeTags.toString() + " in Biomes " + this.biomes.toString() + " + " + this.biomeTags.toString() + " In " + this.dimensions;
    }

    private /* synthetic */ boolean lambda$apply$4(Either unwrappedBiome, Biome b) {
        Biome eBiome = unwrappedBiome.right().orElse(null);
        if (eBiome != null) {
            return this.biomes.contains(eBiome);
        }
        ResourceKey rb = unwrappedBiome.left().orElse(null);
        if (rb != null && (eBiome = (Biome)ForgeRegistries.BIOMES.getValue(rb.m_135782_())) != null) {
            return this.biomes.contains(eBiome);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$apply$3(MobSpawnEvent.FinalizeSpawn evt, TagKey typeTag) {
        return evt.getEntity().m_6095_().m_204039_(typeTag);
    }
}

