/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="item.tooltips.food")
public class FoodTooltipTweak
extends VTweak {
    private ForgeConfigSpec.EnumValue<TooltipSetting> setting;
    private ForgeConfigSpec.DoubleValue multiplier;
    private ForgeConfigSpec.ConfigValue<String> simpleColor;
    private ForgeConfigSpec.ConfigValue<String> buffColor;
    private ForgeConfigSpec.ConfigValue<String> debuffColor;
    private ForgeConfigSpec.ConfigValue<String> saturationColor;
    private ForgeConfigSpec.BooleanValue useOriginalFoodTooltipColor;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.setting = builder.comment("Show food hunger & saturation on item hover").defineEnum("foodTooltipSetting", (Enum)TooltipSetting.WITH_SHIFT);
        this.multiplier = builder.comment("Modifies the number of hunger & saturation points rendered (specifically for Hunger Strike).\nThe original hunger value is multiplied by this value, so 42x means 2 times as much hunger/saturation will render, and 0.5 means half as much hunger/saturation will render.").defineInRange("foodTooltipMultiplier", 1.0, 0.0, 3.4028234663852886E38);
        this.simpleColor = builder.comment("Modifies the color of a tooltip for a food that gives no effects on consumption.\nUses HEX Web Colors which you can pick from here: https://dv2ls.com/colpic").define("foodTooltipColor", (Object)"#00AA00");
        this.buffColor = builder.comment("Modifies the color of a tooltip for a food that gives buffs on consumption.\nUses HEX Web Colors which you can pick from here: https://dv2ls.com/colpic").define("foodTooltipPositiveColor", (Object)"#AA00AA");
        this.debuffColor = builder.comment("Modifies the color of a tooltip for a food that gives debuffs on consumption.\nUses HEX Web Colors which you can pick from here: https://dv2ls.com/colpic").define("foodTooltipNegativeColor", (Object)"#AA0000");
        this.saturationColor = builder.comment("Modifies the color of the saturation tooltip.\nUses HEX Web Colors which you can pick from here: https://dv2ls.com/colpic").define("foodTooltipSaturationColor", (Object)"#AA0000");
        this.useOriginalFoodTooltipColor = builder.comment("If a food has a custom color, use that color instead of the defined color regardless of the buffs/debuffs the food gives").define("useOriginalFoodTooltipColor", true);
        builder.pop(2);
    }

    @SubscribeEvent
    public void process(ItemTooltipEvent evt) {
        if (this.setting.get() == TooltipSetting.NEVER) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        FoodProperties food = stack.getFoodProperties((LivingEntity)evt.getEntity());
        boolean shifting = Screen.m_96638_();
        if (!stack.m_41614_() || food == null) {
            return;
        }
        if (this.setting.get() == TooltipSetting.WITH_SHIFT && !shifting) {
            return;
        }
        evt.getToolTip().add(this.getHungerString(stack, food, stack.m_41791_()));
        evt.getToolTip().add(this.getSaturationString((int)((double)(food.m_38745_() * 10.0f) * (Double)this.multiplier.get()), stack.m_41791_()));
    }

    private boolean hasBadEffect(List<Pair<MobEffectInstance, Float>> e) {
        return e.stream().anyMatch(x -> !((MobEffectInstance)x.getFirst()).m_19544_().m_19486_());
    }

    private boolean hasGoodEffect(List<Pair<MobEffectInstance, Float>> e) {
        return e.stream().anyMatch(x -> ((MobEffectInstance)x.getFirst()).m_19544_().m_19486_());
    }

    private MutableComponent getHungerString(ItemStack stack, FoodProperties food, Rarity rarity) {
        int nutrition = (int)((double)food.m_38744_() * (Double)this.multiplier.get());
        String color = (String)this.simpleColor.get();
        if (((Boolean)this.useOriginalFoodTooltipColor.get()).booleanValue() && stack.m_41786_().m_7383_().m_131135_() != null) {
            color = String.format(Locale.ROOT, "#%06X", stack.m_41786_().m_7383_().m_131135_().m_131265_());
        } else if (((Boolean)this.useOriginalFoodTooltipColor.get()).booleanValue() && stack.m_41611_().m_7383_().m_131135_() != null && stack.m_41611_().m_7383_().m_131135_().m_131265_() != 0xFFFFFF) {
            color = String.format(Locale.ROOT, "#%06X", stack.m_41611_().m_7383_().m_131135_().m_131265_());
        } else if (this.hasBadEffect(food.m_38749_())) {
            color = (String)this.debuffColor.get();
        } else if (this.hasGoodEffect(food.m_38749_())) {
            color = (String)this.buffColor.get();
        }
        Style style = Style.f_131099_.m_131148_(TextColor.m_131268_((String)color)).m_131150_(Style.f_131100_);
        rarity.getStyleModifier().apply(style);
        StringBuilder ret = new StringBuilder();
        ret.append("\u2588".repeat(Math.max(0, nutrition / 2)));
        if (nutrition % 2 != 0) {
            ret.append("\u258c");
        }
        TranslatableContents t = new TranslatableContents("vtweaks.hunger.tooltip.text", "--", new Object[]{ret.toString()});
        try {
            return t.m_213698_(null, null, 0).m_6270_(style);
        }
        catch (CommandSyntaxException e) {
            return Component.m_237119_();
        }
    }

    private MutableComponent getSaturationString(int saturation, Rarity rarity) {
        Style style = Style.f_131099_.m_131148_(TextColor.m_131268_((String)((String)this.saturationColor.get()))).m_131150_(Style.f_131100_);
        rarity.getStyleModifier().apply(style);
        StringBuilder ret = new StringBuilder();
        ret.append("\u2588".repeat(Math.max(0, saturation / 2)));
        if (saturation % 2 != 0) {
            ret.append("\u258c");
        }
        TranslatableContents t = new TranslatableContents("vtweaks.saturation.tooltip.text", "--", new Object[]{ret.toString()});
        try {
            return t.m_213698_(null, null, 0).m_6270_(style);
        }
        catch (CommandSyntaxException e) {
            return Component.m_237119_();
        }
    }

    public static enum TooltipSetting {
        NEVER,
        WITH_SHIFT,
        ALWAYS;

    }
}

