/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.core;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;

public class TweakRegistry {
    final List<VTweak> clientTweaks = Lists.newArrayList();
    final List<VTweak> commonTweaks = Lists.newArrayList();

    public TweakRegistry() {
        Type type = Type.getType(Tweak.class);
        List scanData = ModList.get().getAllScanData();
        LinkedHashSet moduleClassNames = new LinkedHashSet();
        scanData.forEach(s -> s.getAnnotations().forEach(a -> {
            if (Objects.equals(a.annotationType(), type)) {
                moduleClassNames.add(a.memberName());
            }
        }));
        moduleClassNames.forEach(clsNm -> {
            try {
                Class<?> cls = Class.forName(clsNm);
                Class<VTweak> inst = cls.asSubclass(VTweak.class);
                Constructor<VTweak> constructor = inst.getDeclaredConstructor(new Class[0]);
                VTweak instance = constructor.newInstance(new Object[0]);
                if (instance.getCategory().startsWith("client")) {
                    this.clientTweaks.add(instance);
                } else {
                    this.commonTweaks.add(instance);
                }
                NeoForge.EVENT_BUS.register((Object)instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LogManager.getLogger().error("Failed to load annotation {}", clsNm, (Object)e);
            }
        });
        this.clientTweaks.sort(Comparator.comparing(VTweak::getCategory));
        this.commonTweaks.sort(Comparator.comparing(VTweak::getCategory));
    }

    public List<VTweak> getClientTweaks() {
        return this.clientTweaks;
    }

    public List<VTweak> getCommonTweaks() {
        return this.commonTweaks;
    }
}

