/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.anvil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.data.anvil.AnvilRecipeInput;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeSerializers;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeTypes;
import java.util.Arrays;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements Recipe<AnvilRecipeInput> {
    private final Ingredient left;
    private final Ingredient right;
    private final ItemStack result;
    private final int cost;
    private final boolean copyNbtFromLeft;
    private final boolean copyNbtFromRight;
    private final boolean strictMatch;

    public AnvilRecipe(Ingredient leftIn, Ingredient rightIn, ItemStack resultIn, int xpCostIn, boolean copyComponentsFromLeftIn, boolean copyComponentsFromRightIn, boolean strictMatchIn) {
        this.left = leftIn;
        this.right = rightIn;
        this.result = resultIn;
        this.cost = xpCostIn;
        this.copyNbtFromLeft = copyComponentsFromLeftIn;
        this.copyNbtFromRight = copyComponentsFromRightIn;
        this.strictMatch = strictMatchIn;
    }

    public Ingredient getLeft() {
        return this.left;
    }

    public Ingredient getRight() {
        return this.right;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public int getCost() {
        return this.cost;
    }

    public boolean copyComponentsFromLeft() {
        return this.copyNbtFromLeft;
    }

    public boolean copyComponentsFromRight() {
        return this.copyNbtFromRight;
    }

    public boolean isStrictMatch() {
        return this.strictMatch;
    }

    public boolean matches(@NotNull AnvilRecipeInput anvilRecipeInput, @NotNull Level level) {
        boolean rightCompVerified;
        boolean leftCompVerified;
        ItemStack l = anvilRecipeInput.getItem(0);
        ItemStack r = anvilRecipeInput.getItem(1);
        if (!this.left.test(l) || !this.right.test(r)) {
            return false;
        }
        if (!this.isStrictMatch()) {
            return true;
        }
        ItemStack leftIngredientMatch = Arrays.stream(this.left.getItems()).filter(x -> x.getItem() == l.getItem()).findFirst().orElse(ItemStack.EMPTY);
        ItemStack rightIngredientMatch = Arrays.stream(this.right.getItems()).filter(x -> x.getItem() == r.getItem()).findFirst().orElse(ItemStack.EMPTY);
        if (rightIngredientMatch.isEmpty() || leftIngredientMatch.isEmpty()) {
            VTweaks.getInstance().LOGGER.error("Anvil recipe [{} + {}] met an invalid state in AnvilRecipes#matches", (Object)l.toString(), (Object)r.toString());
            return false;
        }
        boolean bl = leftCompVerified = leftIngredientMatch.getComponents().isEmpty() && l.getComponents().isEmpty();
        if (!leftIngredientMatch.getComponents().isEmpty()) {
            leftCompVerified = !l.getComponents().isEmpty() && this.doComponentsMatch(leftIngredientMatch.getComponents(), l.getComponents());
        }
        boolean bl2 = rightCompVerified = rightIngredientMatch.getComponents().isEmpty() && r.getComponents().isEmpty();
        if (!rightIngredientMatch.getComponents().isEmpty()) {
            rightCompVerified = !r.getComponents().isEmpty() && this.doComponentsMatch(rightIngredientMatch.getComponents(), r.getComponents());
        }
        return leftCompVerified && rightCompVerified;
    }

    @NotNull
    public ItemStack assemble(@NotNull AnvilRecipeInput __, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider ___) {
        return this.result.copy();
    }

    private boolean doComponentsMatch(DataComponentMap orig, DataComponentMap comp) {
        if (orig.size() == comp.size()) {
            return false;
        }
        for (DataComponentType origKey : orig.keySet()) {
            Object value = orig.get(origKey);
            if (comp.has(origKey)) {
                if (comp.get(origKey) == value) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean canCraftInDimensions(int _a, int _b) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider __) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.ANVIL.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.ANVIL.get();
    }

    public static class Type
    implements RecipeType<AnvilRecipe> {
        public String toString() {
            return "vtweaks:anvil";
        }
    }

    public static class Serializer
    implements RecipeSerializer<AnvilRecipe> {
        public static final MapCodec<AnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("left").forGetter(AnvilRecipe::getLeft), (App)Ingredient.CODEC.fieldOf("right").forGetter(AnvilRecipe::getRight), (App)ItemStack.CODEC.fieldOf("result").forGetter(AnvilRecipe::getResult), (App)Codec.INT.fieldOf("xpCost").forGetter(AnvilRecipe::getCost), (App)Codec.BOOL.fieldOf("copyCompsFromLeft").forGetter(AnvilRecipe::copyComponentsFromLeft), (App)Codec.BOOL.fieldOf("copyCompsFromRight").forGetter(AnvilRecipe::copyComponentsFromRight), (App)Codec.BOOL.fieldOf("strict").forGetter(AnvilRecipe::isStrictMatch)).apply((Applicative)inst, AnvilRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, AnvilRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getLeft());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getRight());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResult());
            buf.writeInt(recipe.getCost());
            buf.writeBoolean(recipe.copyComponentsFromLeft());
            buf.writeBoolean(recipe.copyComponentsFromRight());
            buf.writeBoolean(recipe.isStrictMatch());
        }

        public static AnvilRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient left = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient right = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int cost = buf.readInt();
            boolean cpFromLeft = buf.readBoolean();
            boolean cpFromRight = buf.readBoolean();
            boolean strict = buf.readBoolean();
            return new AnvilRecipe(left, right, output, cost, cpFromLeft, cpFromRight, strict);
        }

        @NotNull
        public MapCodec<AnvilRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

