/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.challenger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ChallengerDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ChallengerDataLoader() {
        super(GSON, "challenger_mobs");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> dataMap, @Nonnull ResourceManager mgr, @NotNull ProfilerFiller prof) {
        ChallengerEntityModifier.AllVariants.clear();
        dataMap.forEach((rl, json) -> {
            try {
                JsonObject obj = json.getAsJsonObject();
                if (obj.entrySet().isEmpty()) {
                    VTweaks.getInstance().LOGGER.info("Challenger mob {} has been disabled", rl);
                } else {
                    HolderLookup.Provider x = this.getRegistryLookup();
                    ChallengerEntityModifier modifier = new ChallengerEntityModifier(x, obj);
                    ChallengerEntityModifier.AllVariants.add(modifier, modifier.getWeight());
                    VTweaks.getInstance().LOGGER.info("Successfully added new Challenger Mob {} ({})", (Object)modifier.getUnlocalizedName(), rl);
                }
            }
            catch (NullPointerException ex) {
                VTweaks.getInstance().LOGGER.error("Skipping registration of Challenger Mob {} due to errors", rl);
                ex.printStackTrace();
            }
        });
    }
}

