/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.fluidconversion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipeInput;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeSerializers;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeTypes;
import com.oitsjustjose.vtweaks.common.tweaks.recipe.FluidConversionDispensing;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.jetbrains.annotations.NotNull;

public class FluidConversionRecipe
implements Recipe<FluidConversionRecipeInput> {
    private final Ingredient input;
    private final ItemStack result;
    private final ResourceLocation fluid;

    public FluidConversionRecipe(Ingredient input, ItemStack output, ResourceLocation fluid) {
        this.input = input;
        this.result = output;
        this.fluid = fluid;
        for (ItemStack stack : this.input.getItems()) {
            DispenserBlock.registerBehavior((ItemLike)stack.getItem(), (DispenseItemBehavior)new FluidConversionDispensing());
        }
    }

    public boolean matches(FluidConversionRecipeInput recipeInput, @NotNull Level __) {
        return this.input.test(recipeInput.input());
    }

    @NotNull
    public ItemStack assemble(@NotNull FluidConversionRecipeInput __, @NotNull HolderLookup.Provider ___) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider __) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.FLUID_CONVERSION.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.FLUID_CONVERSION.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getFluid() {
        return this.fluid;
    }

    public static class Type
    implements RecipeType<FluidConversionRecipe> {
        public String toString() {
            return "vtweaks:fluid_conversion";
        }
    }

    public static class Serializer
    implements RecipeSerializer<FluidConversionRecipe> {
        public static final MapCodec<FluidConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(FluidConversionRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(FluidConversionRecipe::getResult), (App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(FluidConversionRecipe::getFluid)).apply((Applicative)inst, FluidConversionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, FluidConversionRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getInput());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResult());
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)recipe.getFluid());
        }

        public static FluidConversionRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            ResourceLocation fluid = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
            return new FluidConversionRecipe(input, result, fluid);
        }

        @NotNull
        public MapCodec<FluidConversionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FluidConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

