/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.util.WeightedCollection;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JsonUtils {
    public static ItemStack deserializeItemStack(HolderLookup.Provider provider, JsonObject parent, String key) {
        if (!parent.has(key)) {
            return ItemStack.EMPTY;
        }
        try {
            RegistryOps ctx = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            return (ItemStack)ItemStack.CODEC.parse((DynamicOps)ctx, (Object)parent.getAsJsonObject(key)).getOrThrow();
        }
        catch (IllegalStateException | NoSuchElementException ex) {
            VTweaks.getInstance().LOGGER.error("Item {} does not exist", (Object)parent.get(key).toString());
            VTweaks.getInstance().LOGGER.error((Object)ex);
            return ItemStack.EMPTY;
        }
    }

    public static ArrayList<MobEffectInstance> deserializeEffectInstanceList(JsonArray arr) {
        ArrayList<MobEffectInstance> effs = new ArrayList<MobEffectInstance>();
        for (JsonElement jsonElement : arr) {
            MobEffectInstance ins = JsonUtils.deserializeEffectInstance(jsonElement.getAsJsonObject());
            if (ins == null) continue;
            effs.add(ins);
        }
        return effs;
    }

    @Nullable
    public static MobEffectInstance deserializeEffectInstance(JsonObject json) {
        try {
            String name = json.get("name").getAsString();
            int amplifier = json.has("amplifier") ? json.get("amplifier").getAsInt() : 0;
            int duration = json.has("duration") ? json.get("duration").getAsInt() : 100;
            Optional effectReference = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)name));
            if (effectReference.isEmpty()) {
                VTweaks.getInstance().LOGGER.info("Effect {} is not a valid effect", (Object)name);
                return null;
            }
            return new MobEffectInstance((Holder)effectReference.get(), duration, amplifier);
        }
        catch (NullPointerException ex) {
            VTweaks.getInstance().LOGGER.error("Received invalid effect: {}", (Object)json);
            VTweaks.getInstance().LOGGER.error((Object)ex);
            return null;
        }
    }

    @Nonnull
    public static WeightedCollection<ItemStack> deserializeLootTable(HolderLookup.Provider provider, JsonArray table) {
        WeightedCollection<ItemStack> loot = new WeightedCollection<ItemStack>();
        for (JsonElement jsonElement : table) {
            JsonObject obj = jsonElement.getAsJsonObject();
            int chance = obj.get("weight").getAsInt();
            ItemStack item = JsonUtils.deserializeItemStack(provider, obj, "item");
            loot.add(item, chance);
        }
        return loot;
    }
}

