/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BetterFallingBlock
extends FallingBlockEntity {
    private BlockState heldState;

    public BetterFallingBlock(Level level, @Nonnull BlockState heldState) {
        super(EntityType.FALLING_BLOCK, level);
        super.setUUID(UUID.randomUUID());
        this.heldState = heldState;
    }

    public BetterFallingBlock(Level level, double x, double y, double z, @Nonnull BlockState heldState) {
        this(level, heldState);
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public static BetterFallingBlock fall(Level level, BlockPos pos, BlockState heldState) {
        BetterFallingBlock ent = new BetterFallingBlock(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, heldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)heldState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE) : heldState);
        level.setBlock(pos, heldState.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)ent);
        return ent;
    }

    @NotNull
    public BlockState getBlockState() {
        return this.heldState;
    }

    public void tick() {
        if (this.heldState.isAir()) {
            this.discard();
        }
        Block block = this.heldState.getBlock();
        ++this.time;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            BlockPos blockpos = this.blockPosition();
            if (!this.onGround()) {
                if (!(this.level().isClientSide || (this.time <= 100 || blockpos.getY() > this.level().getMinBuildHeight() && blockpos.getY() <= this.level().getMaxBuildHeight()) && this.time <= 600)) {
                    Level level;
                    if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && (level = this.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        Block.getDrops((BlockState)this.heldState, (ServerLevel)serverLevel, (BlockPos)blockpos, null).forEach(arg_0 -> ((BetterFallingBlock)this).spawnAtLocation(arg_0));
                    }
                    this.discard();
                }
            } else {
                boolean canBePlacedHere;
                BlockState state = this.level().getBlockState(blockpos);
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                boolean canReplace = state.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockpos, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                boolean bl = canBePlacedHere = this.heldState.canSurvive((LevelReader)this.level(), blockpos) && !FallingBlock.isFree((BlockState)this.level().getBlockState(blockpos.below()));
                if (canReplace && canBePlacedHere) {
                    if (this.heldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockpos).getType() == Fluids.WATER) {
                        this.heldState = (BlockState)this.heldState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE);
                    }
                    if (this.level().setBlock(blockpos, this.heldState, 3)) {
                        ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.level().getBlockState(blockpos)));
                        this.discard();
                        if (block instanceof Fallable) {
                            ((Fallable)block).onLand(this.level(), blockpos, this.heldState, state, (FallingBlockEntity)this);
                        }
                    } else if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.discard();
                        this.callOnBrokenAfterFall(block, blockpos);
                        Level level = this.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            Block.getDrops((BlockState)this.heldState, (ServerLevel)serverLevel, (BlockPos)blockpos, null).forEach(arg_0 -> ((BetterFallingBlock)this).spawnAtLocation(arg_0));
                        }
                    }
                } else {
                    this.discard();
                    if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.callOnBrokenAfterFall(block, blockpos);
                        Level level = this.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            Block.getDrops((BlockState)this.heldState, (ServerLevel)serverLevel, (BlockPos)blockpos, null).forEach(arg_0 -> ((BetterFallingBlock)this).spawnAtLocation(arg_0));
                        }
                    }
                }
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }
}

