/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.common.data.helpers.JsonUtils;
import com.oitsjustjose.vtweaks.common.util.I18n;
import com.oitsjustjose.vtweaks.common.util.WeightedCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class ChallengerEntityModifier {
    public static final WeightedCollection<ChallengerEntityModifier> AllVariants = new WeightedCollection();
    private final int weight;
    private final String unlocalizedName;
    private final double healthMultiplier;
    private final double speedMultiplier;
    private final ItemStack mainHand;
    private final ItemStack offHand;
    private final ItemStack helmet;
    private final ItemStack chestplate;
    private final ItemStack leggings;
    private final ItemStack boots;
    private final List<MobEffectInstance> effectsOnAttack;
    private final WeightedCollection<ItemStack> loot;
    private final List<ResourceLocation> entityFilter;
    private final boolean entityFilterIsBlacklist;
    Vector3f particleColor;

    public ChallengerEntityModifier(HolderLookup.Provider provider, JsonObject json) {
        if (json == null) {
            throw new NullPointerException("Provided JSON is null");
        }
        this.weight = json.get("weight").getAsInt();
        JsonObject color = json.get("color").getAsJsonObject();
        float r = (float)color.get("red").getAsInt() / 255.0f;
        float g = (float)color.get("green").getAsInt() / 255.0f;
        float b = (float)color.get("blue").getAsInt() / 255.0f;
        this.particleColor = new Vector3f(r, g, b);
        this.unlocalizedName = json.get("unlocalizedName").getAsString();
        this.healthMultiplier = json.get("healthMultiplier").getAsDouble();
        this.speedMultiplier = json.get("speedMultiplier").getAsDouble();
        JsonObject gear = json.get("gear").getAsJsonObject();
        this.mainHand = JsonUtils.deserializeItemStack(provider, gear, "mainHand");
        this.offHand = JsonUtils.deserializeItemStack(provider, gear, "offHand");
        this.helmet = JsonUtils.deserializeItemStack(provider, gear, "helmet");
        this.chestplate = JsonUtils.deserializeItemStack(provider, gear, "chestplate");
        this.leggings = JsonUtils.deserializeItemStack(provider, gear, "leggings");
        this.boots = JsonUtils.deserializeItemStack(provider, gear, "boots");
        this.effectsOnAttack = JsonUtils.deserializeEffectInstanceList(json.get("effectsOnAttack").getAsJsonArray());
        this.loot = JsonUtils.deserializeLootTable(provider, json.get("loot").getAsJsonArray());
        JsonObject entityFilter = json.get("entityFilter").getAsJsonObject();
        this.entityFilterIsBlacklist = entityFilter.get("isBlacklist").getAsBoolean();
        this.entityFilter = new ArrayList<ResourceLocation>();
        for (JsonElement e : entityFilter.get("entities").getAsJsonArray()) {
            this.entityFilter.add(ResourceLocation.parse((String)e.getAsString()));
        }
    }

    public void apply(Monster monster) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            monster.setItemSlot(e, ItemStack.EMPTY);
            monster.setDropChance(e, 0.0f);
        }
        monster.setItemSlot(EquipmentSlot.HEAD, this.helmet.copy());
        monster.setItemSlot(EquipmentSlot.CHEST, this.chestplate.copy());
        monster.setItemSlot(EquipmentSlot.LEGS, this.leggings.copy());
        monster.setItemSlot(EquipmentSlot.FEET, this.boots.copy());
        monster.setItemInHand(InteractionHand.MAIN_HAND, this.mainHand.copy());
        monster.setItemInHand(InteractionHand.OFF_HAND, this.offHand.copy());
        double speed = Objects.requireNonNull(monster.getAttribute(Attributes.MOVEMENT_SPEED)).getBaseValue();
        double health = Objects.requireNonNull(monster.getAttribute(Attributes.MAX_HEALTH)).getBaseValue();
        Objects.requireNonNull(monster.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(speed * this.speedMultiplier);
        Objects.requireNonNull(monster.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(health * this.healthMultiplier);
        monster.setHealth((float)(health * this.healthMultiplier));
        monster.setCustomName(this.mobClassName(monster));
        CompoundTag comp = monster.getPersistentData();
        CompoundTag type = new CompoundTag();
        type.putString("variant", this.unlocalizedName);
        comp.put("challenger_mob_data", (Tag)type);
        monster.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, Integer.MAX_VALUE, 1, true, false));
    }

    private Component mobClassName(Monster mob) {
        return I18n.Translate("vtweaks." + this.unlocalizedName + ".challenger.mob", "Challenger Mob", mob.getName());
    }

    @Nullable
    public ItemStack pickLoot() {
        ItemStack loot = this.loot.pick();
        return loot == null ? null : loot.copy();
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public Vector3f getParticleColor() {
        return this.particleColor;
    }

    public int getWeight() {
        return this.weight;
    }

    public List<MobEffectInstance> getAttackEffects() {
        return this.effectsOnAttack;
    }

    public List<ResourceLocation> getEntityFilter() {
        return this.entityFilter;
    }

    public boolean isEntityFilterIsBlacklist() {
        return this.entityFilterIsBlacklist;
    }
}

