/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.entity;

import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ConvertibleItemEntity
extends ItemEntity {
    private final List<FluidConversionRecipe> recipes;
    private boolean hasBeenConverted;

    public ConvertibleItemEntity(ItemEntity item, List<RecipeHolder<FluidConversionRecipe>> Recipes) {
        super(item.level(), item.getX(), item.getY(), item.getZ(), item.getItem());
        this.recipes = Recipes.stream().map(RecipeHolder::value).toList();
        this.hasBeenConverted = false;
        this.setDeltaMovement(item.getDeltaMovement());
        this.setPickUpDelay(40);
    }

    public void tick() {
        FluidState fluidState;
        if (!this.hasBeenConverted && !(fluidState = this.level().getFluidState(this.blockPosition())).isEmpty()) {
            ResourceLocation rl = NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluidState.getFluidType());
            Optional<FluidConversionRecipe> recipe = this.recipes.stream().filter(x -> x.getFluid().equals((Object)rl)).findFirst();
            if (recipe.isPresent()) {
                ItemStack clone = recipe.get().getResult().copy();
                clone.setCount(this.getItem().getCount());
                if (!this.getItem().getComponents().isEmpty()) {
                    clone.applyComponents(this.getItem().getComponents());
                }
                this.setItem(clone);
                this.hasBeenConverted = true;
            }
        }
        super.tick();
    }
}

