/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.network.packet;

import com.oitsjustjose.vtweaks.client.VTweaksClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ChallengerParticleData(float r, float g, float b, double x, double y, double z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChallengerParticleData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"challenger_particle_packet"));
    public static final StreamCodec<ByteBuf, ChallengerParticleData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, ChallengerParticleData::r, (StreamCodec)ByteBufCodecs.FLOAT, ChallengerParticleData::g, (StreamCodec)ByteBufCodecs.FLOAT, ChallengerParticleData::b, (StreamCodec)ByteBufCodecs.DOUBLE, ChallengerParticleData::x, (StreamCodec)ByteBufCodecs.DOUBLE, ChallengerParticleData::y, (StreamCodec)ByteBufCodecs.DOUBLE, ChallengerParticleData::z, ChallengerParticleData::new);

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(ChallengerParticleData data, IPayloadContext ctx) {
        if (ctx.flow().getReceptionSide() == LogicalSide.CLIENT) {
            ctx.enqueueWork(() -> VTweaksClient.showDustParticle(data));
        }
    }
}

