/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.level.BlockEvent;

@Tweak(category="block")
public class CakeDropTweak
extends VTweak {
    public ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Allows uneaten cake to drop itself when broken").define("enableCakeDrop", true);
    }

    @SubscribeEvent
    public void process(BlockEvent.BreakEvent evt) {
        Integer bites;
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getPlayer().isCreative()) {
            return;
        }
        BlockState state = evt.getState();
        if (state.is(BlockTags.CANDLE_CAKES)) {
            this.dropCake(evt.getPlayer().level(), evt.getPos());
            return;
        }
        if (state.hasProperty((Property)BlockStateProperties.BITES) && (bites = (Integer)state.getValue((Property)BlockStateProperties.BITES)) == 0) {
            this.dropCake(evt.getPlayer().level(), evt.getPos());
        }
    }

    private void dropCake(Level level, BlockPos pos) {
        ItemEntity cakeItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Items.CAKE));
        cakeItem.setPickUpDelay(10);
        level.addFreshEntity((Entity)cakeItem);
    }
}

