/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.BetterFallingBlock;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.level.BlockEvent;

@Tweak(category="block.chopdown")
public class ChopDownTweak
extends VTweak {
    public ModConfigSpec.BooleanValue enabled;
    public ModConfigSpec.IntValue logCount;
    public ModConfigSpec.IntValue leafSearchRad;
    public ModConfigSpec.BooleanValue requireTool;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Trees fall down using falling block entities").define("enabled", true);
        this.logCount = builder.comment("The minimum number of logs above the one broken to be detected as a tree").defineInRange("numLogsRequired", 3, 1, Integer.MAX_VALUE);
        this.leafSearchRad = builder.comment("The radius used to attempt to find leaves to detect a tree. Set this to a large number to detect larger sparse trees (may cause lag)").defineInRange("leafSearchRadius", 64, 1, Integer.MAX_VALUE);
        this.requireTool = builder.comment("If enabled, ChopDown will only work when the player is using the right tool for the log").define("rightToolRequired", false);
    }

    @SubscribeEvent
    public void process(BlockEvent.BreakEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = evt.getLevel();
        BlockPos initPos = evt.getPos();
        Player player = evt.getPlayer();
        if (((Boolean)this.requireTool.get()).booleanValue() && !player.getMainHandItem().isCorrectToolForDrops(evt.getState())) {
            return;
        }
        for (int dy = 0; dy < (Integer)this.logCount.get(); ++dy) {
            if (level.getBlockState(initPos.offset(0, dy, 0)).is(BlockTags.LOGS)) continue;
            return;
        }
        int leaves = 5;
        Integer rad = (Integer)this.leafSearchRad.get();
        boolean foundLeaves = false;
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashMap<BlockPos, Integer> used = new HashMap<BlockPos, Integer>();
        queue.add(initPos);
        used.put(initPos, leaves);
        while (!queue.isEmpty()) {
            BlockPos top = (BlockPos)queue.pollFirst();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        boolean isLeaf;
                        BlockPos tmp = top.offset(dx, dy, dz);
                        Integer step = (Integer)used.get(top);
                        if (step <= 0 || tmp.distSqr((Vec3i)initPos) > (double)(rad * rad)) continue;
                        BlockState state = level.getBlockState(tmp);
                        boolean isLog = state.is(BlockTags.LOGS);
                        boolean bl = isLeaf = state.is(BlockTags.LEAVES) && (!state.hasProperty((Property)LeavesBlock.PERSISTENT) || (Boolean)state.getValue((Property)LeavesBlock.PERSISTENT) == false);
                        if (isLeaf && !foundLeaves) {
                            foundLeaves = true;
                        }
                        if ((dy < 0 || step != leaves || !isLog) && !isLeaf) continue;
                        step = step - (isLeaf ? 1 : 0);
                        if (used.containsKey(tmp) && (Integer)used.get(tmp) >= step) continue;
                        used.put(tmp, step);
                        queue.push(tmp);
                    }
                }
            }
        }
        if (!foundLeaves) {
            return;
        }
        Direction dir = this.directionFromPosDiff(player.blockPosition(), initPos);
        used.forEach((pos, cnt) -> {
            if (!initPos.equals(pos) && this.canBeMoved(level, pos.offset(0, -1, 0))) {
                BlockPos transformed = this.getTransform(initPos, (BlockPos)pos, dir);
                this.moveAsBlockEntity(level, (BlockPos)pos, transformed, dir);
            }
        });
    }

    private void moveAsBlockEntity(LevelAccessor level, BlockPos pos, BlockPos newPos, Direction direction) {
        BlockState bs = this.rotate(level, pos, level.getBlockState(pos), direction);
        if (bs.is(BlockTags.LEAVES) && level.getRandom().nextBoolean()) {
            Block.dropResources((BlockState)bs, (LevelAccessor)level, (BlockPos)newPos, null);
        } else {
            BetterFallingBlock falling = BetterFallingBlock.fall((Level)level, newPos, bs);
            level.addFreshEntity((Entity)falling);
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    private BlockPos getTransform(BlockPos initialBreakPos, BlockPos pos, Direction direction) {
        int transformedY = pos.getY() - initialBreakPos.getY();
        return switch (direction) {
            case Direction.SOUTH -> pos.offset(0, 0, 1 + transformedY);
            case Direction.NORTH -> pos.offset(0, 0, -transformedY - 1);
            case Direction.EAST -> pos.offset(1 + transformedY, 0, 0);
            case Direction.WEST -> pos.offset(-transformedY - 1, 0, 0);
            default -> pos;
        };
    }

    private boolean canBeMoved(LevelAccessor level, BlockPos pos) {
        BlockState bs = level.getBlockState(pos);
        return !bs.hasBlockEntity() && (bs.is(BlockTags.LOGS) || bs.is(BlockTags.LEAVES) && bs.hasProperty((Property)LeavesBlock.PERSISTENT) && (Boolean)bs.getValue((Property)LeavesBlock.PERSISTENT) == false || bs.is(BlockTags.BEEHIVES) || bs.isAir());
    }

    private BlockState rotate(LevelAccessor level, BlockPos pos, BlockState state, Direction direction) {
        if (state.hasProperty((Property)RotatedPillarBlock.AXIS)) {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
            BlockState ret = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X));
            return switch (direction) {
                case Direction.SOUTH, Direction.NORTH -> ret.rotate(level, pos, Rotation.CLOCKWISE_90);
                case Direction.EAST, Direction.WEST -> ret;
                default -> state;
            };
        }
        return state;
    }

    private Direction directionFromPosDiff(BlockPos playerPos, BlockPos brokenPos) {
        int dirZ;
        double abZ;
        double x = (double)brokenPos.getX() + 0.5 - (double)playerPos.getX();
        double z = (double)brokenPos.getZ() + 0.5 - (double)playerPos.getZ();
        double abX = Math.abs(x);
        int dirX = abX > (abZ = Math.abs(z)) ? (int)Math.floor(abX / x) : 0;
        int n = dirZ = abX > abZ ? 0 : (int)Math.floor(abZ / z);
        if (dirX != 0) {
            return dirX == 1 ? Direction.EAST : Direction.WEST;
        }
        return dirZ == 1 ? Direction.SOUTH : Direction.NORTH;
    }
}

