/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@Tweak(category="block")
public class CropInteractTweak
extends VTweak {
    public static final TagKey<Item> SEEDS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"seeds"));
    public static final TagKey<Block> CROP_BLACKLIST = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"blacklisted_harvest_crops"));
    public ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Allows right-clicking crops when fully grown to harvest. Adding a block to the #vtweaks:blacklisted_harvest_crops block tag will prevent this tweak from applying to said crop.").define("enableCropTweaks", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.RightClickBlock evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = evt.getPos();
        BlockState state = evt.getLevel().getBlockState(pos);
        Player player = evt.getEntity();
        if (state.is(CROP_BLACKLIST)) {
            return;
        }
        if (!this.canHarvest(state)) {
            return;
        }
        Level level = evt.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLvl = (ServerLevel)level;
            this.harvest(serverLvl, pos, state, player);
        }
        player.swing(InteractionHand.MAIN_HAND);
        evt.setCanceled(true);
    }

    private boolean canHarvest(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.isMaxAge(state);
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_1)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_1) == 1;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_2)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_2) == 2;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_3) == 3;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_4)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_4) == 4;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_5)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_5) == 5;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_7) == 7;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_15)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_15) == 15;
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_25)) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_25) == 25;
        }
        return false;
    }

    private void harvest(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, null);
        level.destroyBlock(pos, false);
        AtomicBoolean planted = new AtomicBoolean(false);
        drops.forEach(drop -> {
            if (!planted.get() && this.tryPlant(level, pos, (ItemStack)drop)) {
                planted.set(true);
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
        });
    }

    private boolean tryPlant(ServerLevel level, BlockPos pos, ItemStack stack) {
        if (!stack.is(SEEDS)) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            DirectionalPlaceContext ctx = new DirectionalPlaceContext((Level)level, pos, Direction.DOWN, stack, Direction.UP);
            return bi.place((BlockPlaceContext)ctx) == InteractionResult.SUCCESS;
        }
        return false;
    }
}

