/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Tweak(category="block")
public class TorchLightingTweak
extends VTweak {
    public static final TagKey<Item> TORCH_ITEM = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"ignition_item"));
    public static final TagKey<Block> TORCH_IGNITE_BL = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"torch_ignition_blacklist"));
    public ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Allows the player to re-light any block with the 'lit' blockstate when holding any #vtweaks:ignition_item (item tag). Blacklist blocks using the #vtweaks:torch_ignition_blacklist block tag.").define("enableTorchLighting", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.RightClickBlock evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        Player player = evt.getEntity();
        Level level = evt.getLevel();
        BlockPos pos = evt.getPos();
        BlockState state = level.getBlockState(pos);
        if (player.isCrouching()) {
            return;
        }
        if (state.is(TORCH_IGNITE_BL)) {
            return;
        }
        if (!state.hasProperty((Property)BlockStateProperties.LIT)) {
            return;
        }
        if (!player.getMainHandItem().is(TORCH_ITEM)) {
            return;
        }
        if (state.getValue((Property)BlockStateProperties.LIT) == Boolean.FALSE && level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 18)) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.15f, 1.0f);
            player.swing(InteractionHand.MAIN_HAND);
            evt.setCancellationResult(InteractionResult.CONSUME);
            evt.setCanceled(true);
        }
    }
}

