/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Tweak(category="entity.featherplucking")
public class FeatherPluckTweak
extends VTweak {
    public static final TagKey<EntityType<?>> CHICKENS = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"chickens"));
    public static final TagKey<Item> SHEARS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/shear"));
    private static final String PLUCK_COOL_DOWN_KEY = "vtweaks:pluck_cool_down";
    private ModConfigSpec.BooleanValue enabled;
    private ModConfigSpec.BooleanValue worksOnBabies;
    private ModConfigSpec.LongValue cooldown;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Allows feathers to be plucked from any #c:chickens using any #c:tools/shear").define("enabled", true);
        this.worksOnBabies = builder.comment("Should baby #c:chickens be able to have feathers plucked from them?").define("worksOnBabies", false);
        this.cooldown = builder.comment("The amount of time (in Milliseconds) between plucks. Defaults to 10 minutes.").defineInRange("cooldownInMilliseconds", 600000L, 1L, Long.MAX_VALUE);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.EntityInteract evt) {
        Player player;
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (!evt.getTarget().getType().is(CHICKENS)) {
            return;
        }
        Entity entity = evt.getTarget();
        if (entity instanceof AgeableMob) {
            AgeableMob aged = (AgeableMob)entity;
            if (!((Boolean)this.worksOnBabies.get()).booleanValue() && aged.isBaby()) {
                return;
            }
        }
        if (!(player = evt.getEntity()).getMainHandItem().is(SHEARS)) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        if (!this.canPluck(evt.getTarget())) {
            return;
        }
        player.swing(InteractionHand.MAIN_HAND, true);
        ItemEntity drop = new ItemEntity(evt.getLevel(), evt.getTarget().getX(), evt.getTarget().getY(), evt.getTarget().getZ(), new ItemStack((ItemLike)Items.FEATHER));
        evt.getLevel().addFreshEntity((Entity)drop);
        evt.getTarget().hurt(player.damageSources().generic(), 0.0f);
        this.setCooldown(evt.getTarget());
        if (!player.isCreative()) {
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, evt.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    private boolean canPluck(Entity entity) {
        CompoundTag tag = entity.getPersistentData();
        if (!tag.contains(PLUCK_COOL_DOWN_KEY)) {
            return true;
        }
        long lastTime = tag.getLong(PLUCK_COOL_DOWN_KEY);
        return System.currentTimeMillis() - lastTime >= (Long)this.cooldown.get();
    }

    private void setCooldown(Entity entity) {
        CompoundTag tag = entity.getPersistentData();
        tag.putLong(PLUCK_COOL_DOWN_KEY, System.currentTimeMillis());
    }
}

