/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.core.TickScheduler;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@Tweak(category="entity")
public class GrieflessCreeperTweak
extends VTweak {
    public static final TagKey<EntityType<?>> CREEPERS = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"creepers"));
    private ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("When any #c:creepers explodes, all blocks destroyed will plop back into place after a few seconds").define("ungriefCreepers", true);
    }

    @SubscribeEvent
    public void process(ExplosionEvent.Detonate evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getExplosion().getDirectSourceEntity() == null) {
            return;
        }
        if (!evt.getExplosion().getDirectSourceEntity().getType().is(CREEPERS)) {
            return;
        }
        Entity exploder = evt.getExplosion().getDirectSourceEntity();
        Level lvl = exploder.level();
        AtomicInteger idx = new AtomicInteger();
        evt.getExplosion().getToBlow().sort(Comparator.comparingInt(Vec3i::getY));
        evt.getExplosion().getToBlow().forEach(pos -> {
            BlockState state = lvl.getBlockState(pos);
            BlockEntity ent = lvl.getBlockEntity(pos);
            if (!state.isAir()) {
                TickScheduler.ScheduledTask restoreTask = new TickScheduler.ScheduledTask(() -> {
                    SoundType soundType = state.getSoundType((LevelReader)lvl, pos, null);
                    lvl.setBlock(pos, state, 1026);
                    lvl.setBlocksDirty(pos, lvl.getBlockState(pos), state);
                    lvl.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, 0.15f, 1.0f);
                    if (ent != null) {
                        lvl.setBlockEntity(ent);
                    }
                }, 5.0f + (float)idx.get() / 25.0f);
                VTweaks.getInstance().Scheduler.addTask(restoreTask);
                idx.getAndIncrement();
            }
        });
        evt.getExplosion().getToBlow().sort((a, b) -> Integer.compare(b.getY(), a.getY()));
        evt.getExplosion().getToBlow().forEach(pos -> {
            lvl.removeBlockEntity(pos);
            lvl.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            lvl.setBlocksDirty(pos, lvl.getBlockState(pos), Blocks.AIR.defaultBlockState());
        });
        evt.getExplosion().clearToBlow();
    }
}

