/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@Tweak(category="entity")
public class PetFriendlyFireTweak
extends VTweak {
    private ModConfigSpec.EnumValue<FFSetting> setting;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.setting = builder.comment("Prevents pets from being hit by friendly fire.\nOWNER prevents only the owner of the pet from hurting a pet, whereas ALL prevents any player from hurting any pet.\nDISABLED disables the tweak.").defineEnum("enablePetFriendlyFireTweak", (Enum)FFSetting.OWNER);
    }

    @SubscribeEvent
    public void process(AttackEntityEvent evt) {
        boolean applyToAny;
        if (this.setting.get() == FFSetting.DISABLED) {
            return;
        }
        Entity entity = evt.getTarget();
        if (!(entity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal pet = (TamableAnimal)entity;
        if (!pet.isTame()) {
            return;
        }
        boolean bl = applyToAny = this.setting.get() == FFSetting.ALL;
        if (applyToAny || pet.getOwner() == evt.getEntity()) {
            evt.setCanceled(true);
        }
    }

    public static enum FFSetting {
        DISABLED,
        OWNER,
        ALL;

    }
}

