/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.challenger;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import com.oitsjustjose.vtweaks.common.tweaks.entity.challenger.ChallengerHelpers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

@Tweak(category="entity.challengers")
public class ChallengerModifierHandler
extends VTweak {
    private ModConfigSpec.BooleanValue enabled;
    private ModConfigSpec.DoubleValue globalChance;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("A data-driven way to make some special mobs with abilities, effects, specialized loot and more!\nSee https://mods.oitsjustjose.com/V-Tweaks/#challengers for datapack documentation").define("enabled", true);
        this.globalChance = builder.comment("Controls the overall chance of attempting to convert a monster to a Challenger.\nThis chance is applied before any Challenger Mob weights or entity filters").defineInRange("globalChance", 0.25, 0.0, 1.0);
    }

    @SubscribeEvent
    public void process(FinalizeSpawnEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if ((Double)this.globalChance.get() <= 0.0) {
            return;
        }
        Mob mob = evt.getEntity();
        if (mob instanceof Monster) {
            Monster monster = (Monster)mob;
            if (evt.getLevel().isClientSide()) {
                return;
            }
            if (evt.getEntity().getPersistentData().contains("challenger_mob_data")) {
                return;
            }
            if (evt.getLevel().getRandom().nextDouble() > (Double)this.globalChance.get()) {
                return;
            }
            if (ChallengerHelpers.hasChallengerEntityModifier((Entity)monster)) {
                return;
            }
            ChallengerEntityModifier modifier = ChallengerHelpers.filterForEntity((Entity)monster).pick();
            if (modifier != null && ChallengerHelpers.canBeChallenger(modifier, (Entity)monster)) {
                modifier.apply(monster);
            }
        }
    }
}

