/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.challenger;

import com.oitsjustjose.vtweaks.client.VTweaksClient;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import com.oitsjustjose.vtweaks.common.network.packet.ChallengerParticleData;
import com.oitsjustjose.vtweaks.common.tweaks.entity.challenger.ChallengerHelpers;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

@Tweak(category="entity.challengers")
public class ChallengerParticleHandler
extends VTweak {
    private ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Enable colored particles for challenger mobs (respects the player's particle setting)").define("enableParticles", true);
    }

    @SubscribeEvent
    public void process(EntityTickEvent.Pre evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (!evt.getEntity().isAlive()) {
            return;
        }
        Entity entity = evt.getEntity();
        if (!(entity instanceof Monster)) {
            return;
        }
        Monster monster = (Monster)entity;
        ChallengerEntityModifier modifier = ChallengerHelpers.getChallengerEntityModifier((Entity)monster);
        if (modifier != null) {
            RandomSource rand = monster.getRandom();
            float noiseX = (float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat() / 2.0f;
            float noiseZ = (float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat() / 2.0f;
            double x = monster.getX() + (double)noiseX;
            double y = rand.nextBoolean() ? monster.getY() + (double)(monster.getBbHeight() / 2.0f) : monster.getY();
            double z = monster.getZ() + (double)noiseZ;
            Vector3f color = modifier.getParticleColor();
            ChallengerParticleData particleData = new ChallengerParticleData(color.x(), color.y(), color.z(), x, y += (double)(rand.nextFloat() + (float)rand.nextInt(1)), z);
            if (FMLEnvironment.dist.isClient()) {
                VTweaksClient.showDustParticle(particleData);
            } else {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)particleData, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

