/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.culling;

import com.mojang.datafixers.util.Either;
import com.oitsjustjose.vtweaks.VTweaks;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

public class EntityCullingRule {
    private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    private final List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
    private final List<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
    private final List<TagKey<EntityType<?>>> entityTypeTags = new ArrayList();
    private final List<ResourceLocation> entityTypes = new ArrayList<ResourceLocation>();

    public EntityCullingRule(List<String> biomeFilterRaw, List<String> dimFilterRaw, List<String> entityFilterRaw) {
        biomeFilterRaw.forEach(x -> {
            try {
                if (x.startsWith("#")) {
                    ResourceLocation location = ResourceLocation.parse((String)x.substring(1));
                    TagKey tagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)location);
                    this.biomeTags.add((TagKey<Biome>)tagKey);
                } else {
                    this.biomes.add(ResourceLocation.parse((String)x));
                }
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in biomes object {}: {}", x, (Object)e);
            }
        });
        dimFilterRaw.forEach(x -> {
            try {
                ResourceLocation location = ResourceLocation.parse((String)x);
                this.dimensions.add(location);
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in dimensions object {}: {}", x, (Object)e);
            }
        });
        entityFilterRaw.forEach(x -> {
            try {
                if (x.startsWith("#")) {
                    ResourceLocation location = ResourceLocation.parse((String)x.substring(1));
                    TagKey tagKey = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)location);
                    this.entityTypeTags.add(tagKey);
                } else {
                    ResourceLocation location = ResourceLocation.parse((String)x);
                    if (BuiltInRegistries.ENTITY_TYPE.containsKey(location)) {
                        this.entityTypes.add(location);
                    } else {
                        VTweaks.getInstance().LOGGER.warn("Entity type {} was not found in the ENTITY_TYPE registry", x);
                    }
                }
            }
            catch (Exception e) {
                VTweaks.getInstance().LOGGER.error("Error processing culled_entity in entities object {}: {}", x, (Object)e);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public boolean apply(FinalizeSpawnEvent evt) {
        hasMatchedOnEntity = this.entityTypes.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)evt.getEntity().getType()));
        hasMatchedOnEntityType = this.entityTypeTags.stream().anyMatch((Predicate<TagKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$apply$3(net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Z)((FinalizeSpawnEvent)evt));
        if (!hasMatchedOnEntity && !hasMatchedOnEntityType) {
            return false;
        }
        lvl = (ServerLevel)evt.getLevel();
        dimName = lvl.dimension().location();
        biomeHolder = lvl.getBiome(evt.getEntity().blockPosition());
        unwrappedBiome = biomeHolder.unwrap();
        biomeRegistry = (Registry)lvl.registryAccess().registry(Registries.BIOME).orElseThrow();
        v0 = hasMatchedOnDim = this.dimensions.isEmpty() != false || this.dimensions.contains(dimName) != false;
        if (this.biomeTags.isEmpty()) ** GOTO lbl-1000
        if (this.biomeTags.stream().anyMatch((Predicate<TagKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, is(net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Z)((Holder)biomeHolder))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        hasMatchedOnBiomeTag = v1;
        hasMatchedOnBiome = this.biomes.isEmpty() != false || this.biomes.stream().anyMatch((Predicate<ResourceLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$apply$4(com.mojang.datafixers.util.Either net.minecraft.core.Registry net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Z)((EntityCullingRule)this, (Either)unwrappedBiome, (Registry)biomeRegistry)) != false;
        return hasMatchedOnDim != false && (hasMatchedOnBiome != false || hasMatchedOnBiomeTag != false);
    }

    public String toString() {
        return "EntityCullingRule for Entities" + this.entityTypes.toString() + " + " + this.entityTypeTags.toString() + " in Biomes " + this.biomes.toString() + " + " + this.biomeTags.toString() + " In " + String.valueOf(this.dimensions);
    }

    private /* synthetic */ boolean lambda$apply$4(Either unwrappedBiome, Registry biomeRegistry, ResourceLocation b) {
        Biome eBiome = unwrappedBiome.right().orElse(null);
        if (eBiome != null) {
            return this.biomes.contains(eBiome);
        }
        ResourceKey rb = unwrappedBiome.left().orElse(null);
        if (rb != null && (eBiome = (Biome)biomeRegistry.get(rb.location())) != null) {
            return this.biomes.contains(eBiome);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$apply$3(FinalizeSpawnEvent evt, TagKey typeTag) {
        return evt.getEntity().getType().is(typeTag);
    }
}

