/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.item;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.util.I18n;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Tweak(category="client.tooltips")
public class DurabilityTooltipTweak
extends VTweak {
    private final ArrayList<ChatFormatting> ColorByIndex = Lists.newArrayList((Object[])new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE});
    private ModConfigSpec.EnumValue<TooltipSetting> setting;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.setting = builder.comment("Show tool durability on item hover").defineEnum("durabilityTooltipSetting", (Enum)TooltipSetting.WITH_SHIFT);
    }

    @SubscribeEvent
    public void process(ItemTooltipEvent evt) {
        if (this.setting.get() == TooltipSetting.NEVER) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        boolean shifting = evt.getFlags().hasShiftDown();
        if (!stack.isDamageableItem()) {
            return;
        }
        if (this.setting.get() == TooltipSetting.WITH_SHIFT && !shifting) {
            return;
        }
        evt.getToolTip().add(this.getDurabilityString(stack));
    }

    private MutableComponent getDurabilityString(ItemStack itemstack) {
        int maxDamage = itemstack.getMaxDamage();
        int currDamage = itemstack.getDamageValue();
        float percentHealth = 1.0f - (float)currDamage / (float)maxDamage;
        int normalized = Math.max(Math.min(Math.round(percentHealth * 10.0f) - 1, 9), 0);
        MutableComponent comp = I18n.Translate("vtweaks.durability.tooltip.text").copy();
        MutableComponent comp2 = Component.literal((String)(maxDamage - currDamage + "/" + maxDamage)).withStyle(this.ColorByIndex.get(normalized));
        return comp.append((Component)comp2);
    }

    public static enum TooltipSetting {
        NEVER,
        WITH_SHIFT,
        ALWAYS;

    }
}

